/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.slf4j;

import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.Marker;

public abstract class LevelledLoggerWrapper
implements Logger {
    protected final Logger delegate;

    LevelledLoggerWrapper(Logger logger) {
        this.delegate = (Logger)Validate.notNull((Object)logger);
    }

    protected abstract int getLevel();

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isDebugEnabled() {
        return this.getLevel() <= 10 && this.delegate.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.getLevel() <= 10 && this.delegate.isDebugEnabled(marker);
    }

    public boolean isErrorEnabled() {
        return this.getLevel() <= 40 && this.delegate.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.getLevel() <= 40 && this.delegate.isErrorEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.getLevel() <= 20 && this.delegate.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.getLevel() <= 20 && this.delegate.isInfoEnabled(marker);
    }

    public boolean isTraceEnabled() {
        return this.getLevel() <= 0 && this.delegate.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.getLevel() <= 0 && this.delegate.isTraceEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.getLevel() <= 30 && this.delegate.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.getLevel() <= 30 && this.delegate.isWarnEnabled(marker);
    }

    public void trace(String msg) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(msg, t);
        }
    }

    public void trace(Marker marker, String msg) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(marker, format, argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.getLevel() <= 0) {
            this.delegate.trace(marker, msg, t);
        }
    }

    public void debug(String msg) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(msg, t);
        }
    }

    public void debug(Marker marker, String msg) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.getLevel() <= 10) {
            this.delegate.debug(marker, msg, t);
        }
    }

    public void info(String msg) {
        if (this.getLevel() <= 20) {
            this.delegate.info(msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.getLevel() <= 20) {
            this.delegate.info(format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 20) {
            this.delegate.info(format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.getLevel() <= 20) {
            this.delegate.info(format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.getLevel() <= 20) {
            this.delegate.info(msg, t);
        }
    }

    public void info(Marker marker, String msg) {
        if (this.getLevel() <= 20) {
            this.delegate.info(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.getLevel() <= 20) {
            this.delegate.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 20) {
            this.delegate.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.getLevel() <= 20) {
            this.delegate.info(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.getLevel() <= 20) {
            this.delegate.info(marker, msg, t);
        }
    }

    public void warn(String msg) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(format, arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(format, arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(format, arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(msg, t);
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.getLevel() <= 30) {
            this.delegate.warn(marker, msg, t);
        }
    }

    public void error(String msg) {
        if (this.getLevel() <= 40) {
            this.delegate.error(msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.getLevel() <= 40) {
            this.delegate.error(format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 40) {
            this.delegate.error(format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.getLevel() <= 40) {
            this.delegate.error(format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.getLevel() <= 40) {
            this.delegate.error(msg, t);
        }
    }

    public void error(Marker marker, String msg) {
        if (this.getLevel() <= 40) {
            this.delegate.error(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.getLevel() <= 40) {
            this.delegate.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.getLevel() <= 40) {
            this.delegate.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.getLevel() <= 40) {
            this.delegate.error(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.getLevel() <= 40) {
            this.delegate.error(marker, msg, t);
        }
    }
}

