/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.json.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.json.util.JsonObjectBuildable;

public class JsonBuilderUtils {
    private JsonBuilderUtils() {
    }

    public static JsonArrayBuilder add(JsonBuilderFactory builderFactory, JsonArrayBuilder builder, Object value) {
        Validate.notNull((Object)builderFactory);
        Validate.notNull((Object)builder);
        if (value == null) {
            return builder.addNull();
        }
        if (value instanceof JsonValue) {
            return builder.add((JsonValue)value);
        }
        if (value instanceof Boolean) {
            return builder.add(((Boolean)value).booleanValue());
        }
        if (value instanceof CharSequence) {
            return builder.add(((Object)((CharSequence)value)).toString());
        }
        if (value instanceof Character) {
            return builder.add(((Character)value).toString());
        }
        if (value instanceof Number) {
            if (value instanceof BigInteger) {
                return builder.add((BigInteger)value);
            }
            if (value instanceof BigDecimal) {
                return builder.add((BigDecimal)value);
            }
            if (value instanceof Double || value instanceof Float) {
                return builder.add(((Number)value).doubleValue());
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                return builder.add(((Number)value).intValue());
            }
            if (value instanceof Long) {
                return builder.add(((Number)value).longValue());
            }
            return builder.add(((Number)value).doubleValue());
        }
        if (value instanceof JsonObjectBuildable) {
            JsonObjectBuilder objectBuilder = builderFactory.createObjectBuilder();
            return builder.add(((JsonObjectBuildable)value).build(builderFactory, objectBuilder));
        }
        if (value instanceof Iterable) {
            JsonArrayBuilder arrayBuilder = builderFactory.createArrayBuilder();
            for (Object item : (Iterable)value) {
                JsonBuilderUtils.add(builderFactory, arrayBuilder, item);
            }
            return builder.add(arrayBuilder);
        }
        if (value.getClass().isArray()) {
            JsonArrayBuilder arrayBuilder = builderFactory.createArrayBuilder();
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                Object item = Array.get(value, index);
                JsonBuilderUtils.add(builderFactory, arrayBuilder, item);
            }
            return builder.add(arrayBuilder);
        }
        if (value instanceof Map) {
            JsonObjectBuilder objectBuilder = builderFactory.createObjectBuilder();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                JsonBuilderUtils.add(builderFactory, objectBuilder, entry.getKey().toString(), entry.getValue());
            }
            return builder.add(objectBuilder);
        }
        return builder.add(value.toString());
    }

    public static JsonObjectBuilder add(JsonBuilderFactory builderFactory, JsonObjectBuilder builder, String name, Object value) {
        Validate.notNull((Object)builderFactory);
        Validate.notNull((Object)builder);
        Validate.notNull((Object)name);
        if (value == null) {
            return builder.addNull(name);
        }
        if (value instanceof JsonValue) {
            return builder.add(name, (JsonValue)value);
        }
        if (value instanceof Boolean) {
            return builder.add(name, ((Boolean)value).booleanValue());
        }
        if (value instanceof CharSequence) {
            return builder.add(name, ((Object)((CharSequence)value)).toString());
        }
        if (value instanceof Character) {
            return builder.add(name, ((Character)value).toString());
        }
        if (value instanceof Number) {
            if (value instanceof BigInteger) {
                return builder.add(name, (BigInteger)value);
            }
            if (value instanceof BigDecimal) {
                return builder.add(name, (BigDecimal)value);
            }
            if (value instanceof Double || value instanceof Float) {
                return builder.add(name, ((Number)value).doubleValue());
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                return builder.add(name, ((Number)value).intValue());
            }
            if (value instanceof Long) {
                return builder.add(name, ((Number)value).longValue());
            }
            return builder.add(name, ((Number)value).doubleValue());
        }
        if (value instanceof JsonObjectBuildable) {
            JsonObjectBuilder objectBuilder = builderFactory.createObjectBuilder();
            return builder.add(name, ((JsonObjectBuildable)value).build(builderFactory, objectBuilder));
        }
        if (value instanceof Iterable) {
            JsonArrayBuilder arrayBuilder = builderFactory.createArrayBuilder();
            for (Object item : (Iterable)value) {
                JsonBuilderUtils.add(builderFactory, arrayBuilder, item);
            }
            return builder.add(name, arrayBuilder);
        }
        if (value.getClass().isArray()) {
            JsonArrayBuilder arrayBuilder = builderFactory.createArrayBuilder();
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                Object item = Array.get(value, index);
                JsonBuilderUtils.add(builderFactory, arrayBuilder, item);
            }
            return builder.add(name, arrayBuilder);
        }
        if (value instanceof Map) {
            JsonObjectBuilder objectBuilder = builderFactory.createObjectBuilder();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                JsonBuilderUtils.add(builderFactory, objectBuilder, entry.getKey().toString(), entry.getValue());
            }
            return builder.add(name, objectBuilder);
        }
        return builder.add(name, value.toString());
    }
}

