/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.configuration;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.analysis.ModelInfoGraphAnalyzer;
import org.hisrc.jsonix.configuration.DependenciesOfMappingConfiguration;
import org.hisrc.jsonix.configuration.IncludesConfiguration;
import org.hisrc.jsonix.configuration.JsonSchemaConfiguration;
import org.hisrc.jsonix.configuration.MappingConfiguration;
import org.hisrc.jsonix.configuration.ModuleConfiguration;
import org.hisrc.jsonix.configuration.OutputConfiguration;
import org.hisrc.jsonix.configuration.exception.AmbiguousMappingNameException;
import org.hisrc.jsonix.configuration.exception.MissingMappinWithNameException;
import org.hisrc.jsonix.configuration.exception.MissingMappingWithIdException;
import org.hisrc.jsonix.context.JsonixContext;
import org.hisrc.jsonix.definition.Mapping;
import org.hisrc.jsonix.definition.Module;
import org.hisrc.jsonix.definition.Modules;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.slf4j.Logger;

@XmlRootElement(name="modules")
@XmlType(propOrder={})
public class ModulesConfiguration {
    public static final String DEFAULT_PREFIX = "jsonix";
    public static final String NAMESPACE_URI = "http://jsonix.highsource.org/customizations";
    public static final String LOCAL_ELEMENT_NAME = "modules";
    public static final QName ELEMENT_NAME = new QName("http://jsonix.highsource.org/customizations", "modules", "jsonix");
    private List<ModuleConfiguration> moduleConfigurations = new LinkedList<ModuleConfiguration>();
    private List<MappingConfiguration> mappingConfigurations = new LinkedList<MappingConfiguration>();
    private List<OutputConfiguration> outputConfigurations = new LinkedList<OutputConfiguration>();
    private List<JsonSchemaConfiguration> jsonSchemaConfigurations = new LinkedList<JsonSchemaConfiguration>();

    public List<ModuleConfiguration> getModuleConfigurations() {
        return this.moduleConfigurations;
    }

    public void setModuleConfigurations(List<ModuleConfiguration> moduleConfigurations) {
        this.moduleConfigurations = moduleConfigurations;
    }

    public List<MappingConfiguration> getMappingConfigurations() {
        return this.mappingConfigurations;
    }

    public void setMappingConfigurations(List<MappingConfiguration> mappingConfigurations) {
        this.mappingConfigurations = mappingConfigurations;
    }

    public List<OutputConfiguration> getOutputConfigurations() {
        return this.outputConfigurations;
    }

    public void setOutputConfigurations(List<OutputConfiguration> outputConfigurations) {
        this.outputConfigurations = outputConfigurations;
    }

    public List<JsonSchemaConfiguration> getJsonSchemaConfigurations() {
        return this.jsonSchemaConfigurations;
    }

    public void setJsonSchemaConfigurations(List<JsonSchemaConfiguration> jsonSchemaConfigurations) {
        this.jsonSchemaConfigurations = jsonSchemaConfigurations;
    }

    public <T, C extends T> Modules<T, C> build(JsonixContext context, MModelInfo<T, C> modelInfo) {
        ModelInfoGraphAnalyzer<T, C> analyzer = new ModelInfoGraphAnalyzer<T, C>(context, modelInfo);
        LinkedList<ModuleConfiguration> moduleConfigurations = new LinkedList<ModuleConfiguration>(this.getModuleConfigurations());
        this.createModuleConfigurationsForMappingConfigurations(moduleConfigurations, this.getMappingConfigurations());
        this.createModuleConfigurationsForUnmappedPackages(analyzer, moduleConfigurations);
        this.assignModuleConfigurationsToMappingConfigurations(moduleConfigurations);
        this.assignDefaultOutputConfigurations(moduleConfigurations);
        this.assignDefaultJsonSchemaConfigurations(moduleConfigurations);
        this.assignMappingNamesAndIdsToMappingConfigurations(context, moduleConfigurations);
        this.assignModuleNamesToModules(context, moduleConfigurations);
        return this.buildModules(context, modelInfo, analyzer, moduleConfigurations);
    }

    private void assignModuleConfigurationsToMappingConfigurations(List<ModuleConfiguration> moduleConfigurations) {
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            for (MappingConfiguration mappingConfiguration : moduleConfiguration.getMappingConfigurations()) {
                mappingConfiguration.setModuleConfiguration(moduleConfiguration);
            }
        }
    }

    private void assignMappingNamesAndIdsToMappingConfigurations(JsonixContext context, List<ModuleConfiguration> moduleConfigurations) {
        HashMap<String, MappingConfiguration> idToMappingConfiguration = new HashMap<String, MappingConfiguration>();
        HashMap<String, List<MappingConfiguration>> nameToMappingConfiguration = new HashMap<String, List<MappingConfiguration>>();
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            for (MappingConfiguration mappingConfiguration : moduleConfiguration.getMappingConfigurations()) {
                this.assignMappingName(mappingConfiguration);
                this.assignMappingId(context, idToMappingConfiguration, nameToMappingConfiguration, mappingConfiguration);
            }
        }
    }

    private void assignModuleNamesToModules(JsonixContext context, List<ModuleConfiguration> moduleConfigurations) {
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            if (moduleConfiguration.getName() != null) continue;
            moduleConfiguration.setName(this.createModuleName(moduleConfiguration.getMappingConfigurations()));
        }
    }

    private <T, C extends T> String createModuleName(Iterable<MappingConfiguration> mappings) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (MappingConfiguration mapping : mappings) {
            if (!first) {
                sb.append("_");
            }
            sb.append(mapping.getName());
            first = false;
        }
        return sb.toString();
    }

    private void assignMappingId(JsonixContext context, Map<String, MappingConfiguration> idToMappingConfiguration, Map<String, List<MappingConfiguration>> nameToMappingConfiguration, MappingConfiguration mappingConfiguration) {
        Logger logger = ((JsonixContext)Validate.notNull((Object)context)).getLoggerFactory().getLogger(ModulesConfiguration.class.getName());
        String mappingName = mappingConfiguration.getName();
        String mappingId = mappingConfiguration.getId();
        if (mappingId != null && idToMappingConfiguration.containsKey(mappingId)) {
            logger.error(MessageFormat.format("Mapping id [{0}] is already defined, generating a new mapping id.", mappingId));
            mappingId = null;
        }
        if (mappingId != null) {
            idToMappingConfiguration.put(mappingId, mappingConfiguration);
        } else {
            List<MappingConfiguration> mappings = nameToMappingConfiguration.get(mappingName);
            if (mappings == null) {
                mappings = new ArrayList<MappingConfiguration>(2);
                logger.debug(MessageFormat.format("Assigning id [{0}] to the mapping with name [{1}].", mappingName, mappingName));
                mappingId = mappingName;
                mappingConfiguration.setId(mappingId);
                mappings.add(mappingConfiguration);
                nameToMappingConfiguration.put(mappingName, mappings);
                idToMappingConfiguration.put(mappingId, mappingConfiguration);
            } else if (mappings.size() == 1) {
                logger.debug(MessageFormat.format("There are more than one mapping with the name [{0}] without id.", mappingName));
                String mappingId0 = mappingName + "-0";
                MappingConfiguration mappingConfiguration0 = mappings.get(0);
                logger.debug(MessageFormat.format("Assigning id [{0}] to the mapping with name [{1}].", mappingId0, mappingName));
                mappingConfiguration0.setId(mappingId0);
                mappingId = mappingName + "-1";
                logger.debug(MessageFormat.format("Assigning id [{0}] to the mapping with name [{1}].", mappingId, mappingName));
                mappingConfiguration.setId(mappingId);
                mappings.add(mappingConfiguration);
                idToMappingConfiguration.remove(mappingName);
                idToMappingConfiguration.put(mappingId0, mappingConfiguration0);
                idToMappingConfiguration.put(mappingId, mappingConfiguration);
            } else {
                mappingId = mappingName + mappings.size();
                logger.debug(MessageFormat.format("Assigning id [{0}] to the mapping with name [{1}].", mappingId, mappingName));
                mappingConfiguration.setId(mappingId);
                mappings.add(mappingConfiguration);
                idToMappingConfiguration.put(mappingId, mappingConfiguration);
            }
        }
    }

    private String assignMappingName(MappingConfiguration mappingConfiguration) {
        String mappingName = mappingConfiguration.getName();
        if (StringUtils.isBlank((CharSequence)mappingName)) {
            String packageName = mappingConfiguration.getPackage();
            if (packageName != null) {
                mappingName = StringUtils.isBlank((CharSequence)packageName) ? "Mapping" : packageName.replace('.', '_');
            }
            mappingConfiguration.setName(mappingName);
        }
        return mappingName;
    }

    private <T, C extends T> void createModuleConfigurationsForUnmappedPackages(ModelInfoGraphAnalyzer<T, C> analyzer, List<ModuleConfiguration> moduleConfigurations) {
        Set<String> packageNames = this.findUnmappedPackageNames(analyzer.getPackageNames(), moduleConfigurations);
        for (String packageName : packageNames) {
            MappingConfiguration mappingConfiguration = new MappingConfiguration();
            mappingConfiguration.setPackage(packageName);
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration();
            moduleConfiguration.getMappingConfigurations().add(mappingConfiguration);
            moduleConfigurations.add(moduleConfiguration);
        }
    }

    private void assignDefaultOutputConfigurations(List<ModuleConfiguration> moduleConfigurations) {
        List<OutputConfiguration> defaultOutputConfigurations = this.createDefaultOutputConfigurations();
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            if (!moduleConfiguration.getOutputConfigurations().isEmpty()) continue;
            moduleConfiguration.getOutputConfigurations().addAll(defaultOutputConfigurations);
        }
    }

    private void assignDefaultJsonSchemaConfigurations(List<ModuleConfiguration> moduleConfigurations) {
        List<JsonSchemaConfiguration> defaultJsonSchemaConfigurations = this.createDefaultJsonSchemaConfigurations();
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            if (!moduleConfiguration.getJsonSchemaConfigurations().isEmpty()) continue;
            moduleConfiguration.getJsonSchemaConfigurations().addAll(defaultJsonSchemaConfigurations);
        }
    }

    private Set<String> findUnmappedPackageNames(Set<String> allPackageNames, List<ModuleConfiguration> moduleConfigurations) {
        HashSet<String> packageNames = new HashSet<String>(allPackageNames);
        HashSet<String> mappedPackagesNames = new HashSet<String>();
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            for (MappingConfiguration mappingConfiguration : moduleConfiguration.getMappingConfigurations()) {
                mappedPackagesNames.add(mappingConfiguration.getPackage());
            }
        }
        packageNames.removeAll(mappedPackagesNames);
        return packageNames;
    }

    private void createModuleConfigurationsForMappingConfigurations(List<ModuleConfiguration> moduleConfigurations, List<MappingConfiguration> mappingConfigurations) {
        for (MappingConfiguration mappingConfiguration : mappingConfigurations) {
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration();
            moduleConfiguration.getMappingConfigurations().add(mappingConfiguration);
            moduleConfigurations.add(moduleConfiguration);
        }
    }

    private List<OutputConfiguration> createDefaultOutputConfigurations() {
        List<OutputConfiguration> defaultOutputConfigurations = this.getOutputConfigurations();
        if (defaultOutputConfigurations.isEmpty()) {
            defaultOutputConfigurations.add(new OutputConfiguration("standard"));
        }
        return defaultOutputConfigurations;
    }

    private List<JsonSchemaConfiguration> createDefaultJsonSchemaConfigurations() {
        List<JsonSchemaConfiguration> defaultJsonSchemaConfigurations = this.getJsonSchemaConfigurations();
        return defaultJsonSchemaConfigurations;
    }

    private <T, C extends T> Modules<T, C> buildModules(JsonixContext context, MModelInfo<T, C> modelInfo, ModelInfoGraphAnalyzer<T, C> analyzer, List<ModuleConfiguration> moduleConfigurations) {
        List<MappingConfiguration> mappingConfigurations = this.getTopologicallyOrderedMappingConfigurations(context, moduleConfigurations);
        Map<String, Mapping<T, C>> mappings = this.buildMappings(context, modelInfo, analyzer, mappingConfigurations);
        ArrayList modules = new ArrayList(moduleConfigurations.size());
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            Module<T, C> module = moduleConfiguration.build(analyzer, modelInfo, mappings);
            if (module == null) continue;
            modules.add(module);
        }
        return new Modules<T, C>(context, modelInfo, modules);
    }

    private <T, C extends T> Map<String, Mapping<T, C>> buildMappings(JsonixContext context, MModelInfo<T, C> modelInfo, ModelInfoGraphAnalyzer<T, C> analyzer, List<MappingConfiguration> mappingConfigurations) {
        Logger logger = ((JsonixContext)Validate.notNull((Object)context)).getLoggerFactory().getLogger(ModulesConfiguration.class.getName());
        HashMap<String, Mapping<T, C>> mappings = new HashMap<String, Mapping<T, C>>();
        for (MappingConfiguration mappingConfiguration : mappingConfigurations) {
            String packageName = mappingConfiguration.getPackage();
            if (packageName == null) {
                logger.warn("At least one of the mapping configurations is missing the required [package] attribute.");
                continue;
            }
            MPackageInfo packageInfo = analyzer.getPackageInfoMap().get(packageName);
            if (packageInfo == null) {
                logger.warn(MessageFormat.format("Package name [{0}] could not be found.", Validate.notNull((Object)packageName)));
                continue;
            }
            Mapping<T, C> mapping = mappingConfiguration.build(context, analyzer, modelInfo, packageInfo, mappings);
            mappings.put(mappingConfiguration.getId(), mapping);
        }
        return mappings;
    }

    private List<MappingConfiguration> getTopologicallyOrderedMappingConfigurations(JsonixContext context, List<ModuleConfiguration> moduleConfigurations) {
        DirectedGraph<MappingConfiguration, Object> mappingConfigurationDependencyGraph = this.buildMappingConfigurationDependencyGraph(context, moduleConfigurations);
        StrongConnectivityInspector strongConnectivityInspector = new StrongConnectivityInspector(mappingConfigurationDependencyGraph);
        List stronglyConnectedSets = strongConnectivityInspector.stronglyConnectedSets();
        for (Set stronglyConnectedSet : stronglyConnectedSets) {
            if (stronglyConnectedSet.size() <= 1) continue;
            throw new IllegalArgumentException(MessageFormat.format("Mappings have the following dependency cycle: {0}", stronglyConnectedSet.toString()));
        }
        ArrayList<MappingConfiguration> mappingConfigurations = new ArrayList<MappingConfiguration>(mappingConfigurationDependencyGraph.vertexSet().size());
        TopologicalOrderIterator mappingConfigurationsInTopologicalOrderIterator = new TopologicalOrderIterator(mappingConfigurationDependencyGraph);
        while (mappingConfigurationsInTopologicalOrderIterator.hasNext()) {
            mappingConfigurations.add((MappingConfiguration)mappingConfigurationsInTopologicalOrderIterator.next());
        }
        return mappingConfigurations;
    }

    private DirectedGraph<MappingConfiguration, Object> buildMappingConfigurationDependencyGraph(JsonixContext context, List<ModuleConfiguration> moduleConfigurations) {
        Logger logger = ((JsonixContext)Validate.notNull((Object)context)).getLoggerFactory().getLogger(ModulesConfiguration.class.getName());
        DefaultDirectedGraph mappingDependenciesGraph = new DefaultDirectedGraph((EdgeFactory)new EdgeFactory<MappingConfiguration, Object>(){

            public Object createEdge(MappingConfiguration sourceVertex, MappingConfiguration targetVertex) {
                return new Object();
            }
        });
        HashMap<String, MappingConfiguration> idToMappingConfiguration = new HashMap<String, MappingConfiguration>();
        HashMap<String, ArrayList<MappingConfiguration>> nameToMappingConfiguration = new HashMap<String, ArrayList<MappingConfiguration>>();
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            for (MappingConfiguration mappingConfiguration : moduleConfiguration.getMappingConfigurations()) {
                String id = mappingConfiguration.getId();
                String name = mappingConfiguration.getName();
                idToMappingConfiguration.put(id, mappingConfiguration);
                ArrayList<MappingConfiguration> mappings = (ArrayList<MappingConfiguration>)nameToMappingConfiguration.get(name);
                if (mappings == null) {
                    mappings = new ArrayList<MappingConfiguration>(2);
                    nameToMappingConfiguration.put(name, mappings);
                }
                mappings.add(mappingConfiguration);
            }
        }
        for (ModuleConfiguration moduleConfiguration : moduleConfigurations) {
            for (MappingConfiguration mappingConfiguration : moduleConfiguration.getMappingConfigurations()) {
                mappingDependenciesGraph.addVertex((Object)mappingConfiguration);
                IncludesConfiguration includesConfiguration = mappingConfiguration.getIncludesConfiguration();
                if (includesConfiguration == null) continue;
                for (DependenciesOfMappingConfiguration dependenciesOfMappingConfiguration : includesConfiguration.getDependenciesOfMappingConfiguration()) {
                    String id = dependenciesOfMappingConfiguration.getId();
                    String name = dependenciesOfMappingConfiguration.getName();
                    MappingConfiguration dependingMappingConfiguration = null;
                    if (id != null) {
                        dependingMappingConfiguration = (MappingConfiguration)idToMappingConfiguration.get(id);
                        if (dependingMappingConfiguration == null) {
                            throw new MissingMappingWithIdException(id);
                        }
                        mappingDependenciesGraph.addVertex((Object)dependingMappingConfiguration);
                        mappingDependenciesGraph.addEdge((Object)dependingMappingConfiguration, (Object)mappingConfiguration);
                        continue;
                    }
                    if (name != null) {
                        List dependingMappingConfigurations = (List)nameToMappingConfiguration.get(name);
                        if (dependingMappingConfigurations == null || dependingMappingConfigurations.isEmpty()) {
                            throw new MissingMappinWithNameException(name);
                        }
                        if (dependingMappingConfigurations.size() > 1) {
                            throw new AmbiguousMappingNameException(name);
                        }
                        dependingMappingConfiguration = (MappingConfiguration)dependingMappingConfigurations.get(0);
                        dependenciesOfMappingConfiguration.setId(dependingMappingConfiguration.getId());
                        mappingDependenciesGraph.addVertex((Object)dependingMappingConfiguration);
                        mappingDependenciesGraph.addEdge((Object)dependingMappingConfiguration, (Object)mappingConfiguration);
                        continue;
                    }
                    logger.warn(MessageFormat.format("Either [id] or [name] must be defined in the  [{0}] element.", "dependencies-of-mapping"));
                }
            }
        }
        return mappingDependenciesGraph;
    }
}

