/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.configuration;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.hisrc.jsonix.analysis.ModelInfoGraphAnalyzer;
import org.hisrc.jsonix.configuration.JsonSchemaConfiguration;
import org.hisrc.jsonix.configuration.MappingConfiguration;
import org.hisrc.jsonix.configuration.OutputConfiguration;
import org.hisrc.jsonix.definition.JsonSchema;
import org.hisrc.jsonix.definition.Mapping;
import org.hisrc.jsonix.definition.Module;
import org.hisrc.jsonix.definition.Output;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;

@XmlRootElement(name="module")
@XmlType(propOrder={})
public class ModuleConfiguration {
    public static final String LOCAL_ELEMENT_NAME = "module";
    public static final String MODULE_NAME_PROPERTY = "${module.name}";
    public static final String MODULE_SCHEMA_ID_PROPERTY = "${module.schemaId}";
    public static final String MODULE_NAME_SEPARATOR = "_";
    private String name;
    private String schemaId = "${module.name}.jsonschema#";
    private List<MappingConfiguration> mappingConfigurations = new LinkedList<MappingConfiguration>();
    private List<OutputConfiguration> outputConfigurations = new LinkedList<OutputConfiguration>();
    private List<JsonSchemaConfiguration> jsonSchemaConfigurations = new LinkedList<JsonSchemaConfiguration>();
    public static final QName MODULE_NAME = new QName("http://jsonix.highsource.org/customizations", "module", "jsonix");

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="schemaId")
    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    @XmlElement(name="mapping")
    public List<MappingConfiguration> getMappingConfigurations() {
        return this.mappingConfigurations;
    }

    public void setMappingConfigurations(List<MappingConfiguration> mappingConfigurations) {
        this.mappingConfigurations = mappingConfigurations;
    }

    @XmlElement(name="output")
    public List<OutputConfiguration> getOutputConfigurations() {
        return this.outputConfigurations;
    }

    public void setOutputConfigurations(List<OutputConfiguration> outputConfigurations) {
        this.outputConfigurations = outputConfigurations;
    }

    @XmlElement(name="jsonSchema")
    public List<JsonSchemaConfiguration> getJsonSchemaConfigurations() {
        return this.jsonSchemaConfigurations;
    }

    public void setJsonSchemaConfigurations(List<JsonSchemaConfiguration> jsonSchemaConfigurations) {
        this.jsonSchemaConfigurations = jsonSchemaConfigurations;
    }

    public <T, C extends T> Module<T, C> build(ModelInfoGraphAnalyzer<T, C> analyzer, MModelInfo<T, C> modelInfo, Map<String, Mapping<T, C>> mappings) {
        List<MappingConfiguration> mappingConfigurations = this.getMappingConfigurations();
        ArrayList moduleMappings = new ArrayList(mappingConfigurations.size());
        for (MappingConfiguration mappingConfiguration : mappingConfigurations) {
            Mapping<T, C> moduleMapping = mappings.get(mappingConfiguration.getId());
            if (moduleMapping == null) continue;
            moduleMappings.add(moduleMapping);
        }
        if (moduleMappings.isEmpty()) {
            return null;
        }
        String moduleName = this.name;
        if (moduleName == null) {
            throw new IllegalStateException("Module name was not assigned yet.");
        }
        String moduleSchemaId = this.schemaId.replace(MODULE_NAME_PROPERTY, moduleName);
        ArrayList<Output> outputs = new ArrayList<Output>(this.outputConfigurations.size());
        for (OutputConfiguration outputConfiguration : this.outputConfigurations) {
            Output output = outputConfiguration.build(moduleName);
            if (output == null) continue;
            outputs.add(output);
        }
        ArrayList<JsonSchema> jsonSchemas = new ArrayList<JsonSchema>(this.jsonSchemaConfigurations.size());
        for (JsonSchemaConfiguration jsonSchemaConfiguration : this.jsonSchemaConfigurations) {
            JsonSchema jsonSchema = jsonSchemaConfiguration.build(moduleName);
            if (jsonSchema == null) continue;
            jsonSchemas.add(jsonSchema);
        }
        return new Module(moduleName, moduleSchemaId, moduleMappings, outputs, jsonSchemas);
    }
}

