/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.mapping.typeinfo.builtin;

import javax.xml.datatype.Duration;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSObjectLiteral;
import org.hisrc.jsonix.compilation.mapping.MappingCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.BuiltinLeafInfoCompiler;
import org.jvnet.jaxb2_commons.xmlschema.XmlSchemaConstants;

public class DurationTypeInfoCompiler<T, C extends T, O>
extends BuiltinLeafInfoCompiler<T, C, O> {
    public DurationTypeInfoCompiler() {
        super("Duration", XmlSchemaConstants.DURATION);
    }

    @Override
    public JSAssignmentExpression createValue(MappingCompiler<T, C> mappingCompiler, String item) {
        JSCodeModel codeModel = mappingCompiler.getCodeModel();
        JSObjectLiteral result = codeModel.object();
        Duration duration = this.datatypeFactory.newDuration(item);
        if (duration.getSign() <= 0) {
            result.append("sign", (JSAssignmentExpression)codeModel.integer((long)duration.getSign()));
        }
        if (duration.getYears() > 0) {
            result.append("years", (JSAssignmentExpression)codeModel.integer((long)duration.getYears()));
        }
        if (duration.getMonths() > 0) {
            result.append("months", (JSAssignmentExpression)codeModel.integer((long)duration.getMonths()));
        }
        if (duration.getDays() > 0) {
            result.append("days", (JSAssignmentExpression)codeModel.integer((long)duration.getDays()));
        }
        if (duration.getHours() > 0) {
            result.append("hours", (JSAssignmentExpression)codeModel.integer((long)duration.getHours()));
        }
        if (duration.getMinutes() > 0) {
            result.append("minutes", (JSAssignmentExpression)codeModel.integer((long)duration.getMinutes()));
        }
        if (duration.getSeconds() > 0) {
            result.append("seconds", (JSAssignmentExpression)codeModel.integer((long)duration.getSeconds()));
        }
        return result;
    }
}

