/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.mapping;

import org.apache.commons.lang3.Validate;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.JSProgram;
import org.hisrc.jscm.codemodel.impl.CodeModelImpl;
import org.hisrc.jsonix.compilation.mapping.ModuleCompiler;
import org.hisrc.jsonix.compilation.mapping.ProgramWriter;
import org.hisrc.jsonix.definition.Module;
import org.hisrc.jsonix.definition.Modules;
import org.hisrc.jsonix.definition.Output;

public class ModulesCompiler<T, C extends T> {
    private final Modules<T, C> modules;

    public ModulesCompiler(Modules<T, C> modules) {
        Validate.notNull(modules);
        this.modules = modules;
    }

    public void compile(ProgramWriter<T, C> programWriter) {
        CodeModelImpl codeModel = new CodeModelImpl();
        for (Module<T, C> module : this.modules.getModules()) {
            if (module.isEmpty()) continue;
            for (Output output : module.getOutputs()) {
                ModuleCompiler<T, C> moduleCompiler = new ModuleCompiler<T, C>((JSCodeModel)codeModel, this.modules, module, output);
                JSProgram program = moduleCompiler.compile();
                programWriter.writeProgram(module, program, output);
            }
        }
    }
}

