/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.mapping;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSArrayLiteral;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSMemberExpression;
import org.hisrc.jscm.codemodel.expression.JSObjectLiteral;
import org.hisrc.jsonix.compilation.mapping.CreateTypeInfoDelaration;
import org.hisrc.jsonix.compilation.mapping.typeinfo.ClassInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.CreateTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.EnumLeafInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.TypeInfoCompiler;
import org.hisrc.jsonix.definition.Mapping;
import org.hisrc.jsonix.definition.MappingDependency;
import org.hisrc.jsonix.definition.Module;
import org.hisrc.jsonix.definition.Modules;
import org.hisrc.jsonix.definition.Output;
import org.hisrc.jsonix.naming.Naming;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MEnumLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MOriginated;

public class MappingCompiler<T, C extends T> {
    public static final String DEFAULT_SCOPED_NAME_DELIMITER = ".";
    private final JSCodeModel codeModel;
    public final String mappingName;
    private final String targetNamespaceURI;
    private final String defaultElementNamespaceURI;
    private final String defaultAttributeNamespaceURI;
    private final Modules<T, C> modules;
    private Naming naming;
    private Mapping<T, C> mapping;
    private Output output;

    public MappingCompiler(JSCodeModel codeModel, Modules<T, C> modules, Module<T, C> module, Output output, Mapping<T, C> mapping) {
        Validate.notNull((Object)codeModel);
        Validate.notNull(modules);
        Validate.notNull(module);
        Validate.notNull(mapping);
        Validate.notNull((Object)output);
        this.codeModel = codeModel;
        this.modules = modules;
        this.mapping = mapping;
        this.mappingName = mapping.getMappingName();
        this.targetNamespaceURI = mapping.getTargetNamespaceURI();
        this.defaultElementNamespaceURI = mapping.getDefaultElementNamespaceURI();
        this.defaultAttributeNamespaceURI = mapping.getDefaultAttributeNamespaceURI();
        this.output = output;
        this.naming = output.getNaming();
    }

    public Modules<T, C> getModules() {
        return this.modules;
    }

    public JSCodeModel getCodeModel() {
        return this.codeModel;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public Mapping<T, C> getMapping() {
        return this.mapping;
    }

    public Output getOutput() {
        return this.output;
    }

    public JSObjectLiteral compile() {
        JSObjectLiteral mappingBody = this.codeModel.object();
        mappingBody.append(this.naming.name(), (JSAssignmentExpression)this.codeModel.string(this.mappingName));
        if (!this.targetNamespaceURI.equals(this.defaultElementNamespaceURI)) {
            mappingBody.append(this.naming.targetNamespaceURI(), (JSAssignmentExpression)this.codeModel.string(this.targetNamespaceURI));
        }
        if (!StringUtils.isEmpty((CharSequence)this.defaultElementNamespaceURI)) {
            mappingBody.append(this.naming.defaultElementNamespaceURI(), (JSAssignmentExpression)this.codeModel.string(this.defaultElementNamespaceURI));
        }
        if (!StringUtils.isEmpty((CharSequence)this.defaultAttributeNamespaceURI)) {
            mappingBody.append(this.naming.defaultAttributeNamespaceURI(), (JSAssignmentExpression)this.codeModel.string(this.defaultAttributeNamespaceURI));
        }
        JSArrayLiteral dependencies = this.codeModel.array();
        this.compileDependencies(dependencies);
        if (!dependencies.getElements().isEmpty()) {
            mappingBody.append(this.naming.dependencies(), (JSAssignmentExpression)dependencies);
        }
        JSArrayLiteral typeInfos = this.codeModel.array();
        mappingBody.append(this.naming.typeInfos(), (JSAssignmentExpression)typeInfos);
        JSArrayLiteral elementInfos = this.codeModel.array();
        mappingBody.append(this.naming.elementInfos(), (JSAssignmentExpression)elementInfos);
        this.compileClassInfos(typeInfos);
        this.compileEnumLeafInfos(typeInfos);
        this.compileElementInfos(elementInfos);
        return mappingBody;
    }

    private void compileDependencies(JSArrayLiteral dependencies) {
        Collection<MappingDependency<T, C>> mappingDependencies = this.mapping.getDirectDependencies();
        LinkedHashSet<String> mappingDependencyNames = new LinkedHashSet<String>();
        for (MappingDependency<T, C> mappingDependency : mappingDependencies) {
            MPackageInfo dependencyPackageInfo = mappingDependency.getPackageInfo();
            String dependencyPackageName = dependencyPackageInfo.getPackageName();
            String dependencyMappingName = this.modules.getMappingName(dependencyPackageName);
            mappingDependencyNames.add(dependencyMappingName);
        }
        for (String mappingDependencyName : mappingDependencyNames) {
            dependencies.append(new JSAssignmentExpression[]{this.getCodeModel().string(mappingDependencyName)});
        }
    }

    private void compileClassInfos(JSArrayLiteral typeInfos) {
        for (MClassInfo<T, C> classInfo : this.mapping.getClassInfos()) {
            typeInfos.append(new JSAssignmentExpression[]{this.compileClassInfo(classInfo)});
        }
    }

    private void compileEnumLeafInfos(JSArrayLiteral typeInfos) {
        for (MEnumLeafInfo<T, C> enumLeafInfo : this.mapping.getEnumLeafInfos()) {
            typeInfos.append(new JSAssignmentExpression[]{this.compileEnumLeafInfo(enumLeafInfo)});
        }
    }

    private JSObjectLiteral compileClassInfo(MClassInfo<T, C> classInfo) {
        return new ClassInfoCompiler<T, C>(classInfo).compile(this);
    }

    private JSObjectLiteral compileEnumLeafInfo(MEnumLeafInfo<T, C> enumLeafInfo) {
        return new EnumLeafInfoCompiler<T, C>(enumLeafInfo).compile(this);
    }

    private void compileElementInfos(JSArrayLiteral eis) {
        for (MElementInfo<T, C> elementInfo : this.mapping.getElementInfos()) {
            eis.append(new JSAssignmentExpression[]{this.compileElementInfo(elementInfo)});
        }
    }

    private JSObjectLiteral compileElementInfo(MElementInfo<T, C> elementInfo) {
        MTypeInfo typeInfo = elementInfo.getTypeInfo();
        MClassInfo scope = elementInfo.getScope();
        QName substitutionHead = elementInfo.getSubstitutionHead();
        JSObjectLiteral value = this.codeModel.object();
        typeInfo.acceptTypeInfoVisitor(new CreateTypeInfoDelaration(this, elementInfo, value));
        QName elementName = elementInfo.getElementName();
        value.append(this.naming.elementName(), (JSAssignmentExpression)this.createElementNameExpression(elementName));
        if (scope != null) {
            value.append(this.naming.scope(), this.getTypeInfoCompiler((MOriginated)elementInfo, (MTypeInfo<T, C>)scope).createTypeInfoDeclaration(this));
        }
        if (substitutionHead != null) {
            value.append(this.naming.substitutionHead(), (JSAssignmentExpression)this.createElementNameExpression(substitutionHead));
        }
        return value;
    }

    public JSMemberExpression createElementNameExpression(QName name) {
        Validate.notNull((Object)name);
        return this.createNameExpression(name, this.defaultElementNamespaceURI);
    }

    public JSMemberExpression createAttributeNameExpression(QName name) {
        Validate.notNull((Object)name);
        return this.createNameExpression(name, this.defaultAttributeNamespaceURI);
    }

    private JSMemberExpression createNameExpression(QName name, String defaultNamespaceURI) {
        String namespaceURI;
        String draftNamespaceURI = name.getNamespaceURI();
        String string = namespaceURI = StringUtils.isEmpty((CharSequence)draftNamespaceURI) ? null : draftNamespaceURI;
        if (ObjectUtils.equals((Object)defaultNamespaceURI, (Object)namespaceURI)) {
            return this.codeModel.string(name.getLocalPart());
        }
        JSObjectLiteral nameExpression = this.codeModel.object();
        nameExpression.append(this.naming.localPart(), (JSAssignmentExpression)this.codeModel.string(name.getLocalPart()));
        if (!StringUtils.isEmpty((CharSequence)namespaceURI)) {
            nameExpression.append(this.naming.namespaceURI(), (JSAssignmentExpression)this.codeModel.string(namespaceURI));
        }
        return nameExpression;
    }

    public <O> TypeInfoCompiler<T, C> getTypeInfoCompiler(MOriginated<O> originated, MTypeInfo<T, C> typeInfo) {
        return (TypeInfoCompiler)typeInfo.acceptTypeInfoVisitor(new CreateTypeInfoCompiler(originated));
    }
}

