/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.jsonschema;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.JsonBuilderFactory;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.compilation.jsonschema.JsonSchemaMappingCompiler;
import org.hisrc.jsonix.definition.JsonSchema;
import org.hisrc.jsonix.definition.Mapping;
import org.hisrc.jsonix.definition.Module;
import org.hisrc.jsonix.definition.Modules;
import org.hisrc.jsonix.jsonschema.JsonSchemaBuilder;

public class JsonSchemaModuleCompiler<T, C extends T> {
    private final Modules<T, C> modules;
    private final Module<T, C> module;
    private final JsonBuilderFactory jsonBuilderFactory;

    public JsonSchemaModuleCompiler(JsonBuilderFactory jsonBuilderFactory, Modules<T, C> modules, Module<T, C> module, JsonSchema jsonSchema) {
        Validate.notNull((Object)jsonBuilderFactory);
        Validate.notNull(module);
        Validate.notNull((Object)jsonSchema);
        this.jsonBuilderFactory = jsonBuilderFactory;
        this.modules = modules;
        this.module = module;
    }

    public JsonBuilderFactory getJsonBuilderFactory() {
        return this.jsonBuilderFactory;
    }

    public Modules<T, C> getModules() {
        return this.modules;
    }

    public Module<T, C> getModule() {
        return this.module;
    }

    public JsonSchemaBuilder compile() {
        JsonSchemaBuilder schema;
        LinkedHashMap<Mapping<T, C>, JsonSchemaBuilder> mappingSchemas = new LinkedHashMap<Mapping<T, C>, JsonSchemaBuilder>(this.module.getMappings().size());
        for (Mapping<T, C> mapping : this.module.getMappings()) {
            if (mapping.isEmpty()) continue;
            JsonSchemaMappingCompiler<T, C> mappingCompiler = new JsonSchemaMappingCompiler<T, C>(this.jsonBuilderFactory, this.modules, this.module, mapping);
            mappingSchemas.put(mapping, mappingCompiler.compile());
        }
        if (mappingSchemas.size() == 1) {
            schema = (JsonSchemaBuilder)mappingSchemas.values().iterator().next();
        } else {
            schema = new JsonSchemaBuilder();
            schema.addId(this.getModule().getSchemaId());
            for (Map.Entry entry : mappingSchemas.entrySet()) {
                Mapping mapping = (Mapping)entry.getKey();
                JsonSchemaBuilder mappingSchema = (JsonSchemaBuilder)entry.getValue();
                schema.addDefinition(mapping.getMappingName(), mappingSchema);
                schema.addAnyOf(new JsonSchemaBuilder().addRef(mapping.getSchemaId()));
            }
        }
        return schema;
    }
}

