/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.analysis;

import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.analysis.InfoVertex;
import org.hisrc.jsonix.analysis.ModelInfoGraphBuilder;
import org.hisrc.jsonix.analysis.PackageInfoVertex;
import org.hisrc.jsonix.analysis.PropertyInfoVertex;
import org.hisrc.jsonix.analysis.TypeInfoVertex;
import org.jvnet.jaxb2_commons.xml.bind.model.MBuiltinLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassRef;
import org.jvnet.jaxb2_commons.xml.bind.model.MEnumLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MID;
import org.jvnet.jaxb2_commons.xml.bind.model.MIDREF;
import org.jvnet.jaxb2_commons.xml.bind.model.MIDREFS;
import org.jvnet.jaxb2_commons.xml.bind.model.MList;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.MWildcardTypeInfo;

public class TypeInfoGraphBuilder<T, C extends T>
implements MTypeInfoVisitor<T, C, TypeInfoVertex<T, C>> {
    private final ModelInfoGraphBuilder<T, C> modelInfoGraphBuilder;
    private final MPackageInfo packageInfo;

    public TypeInfoGraphBuilder(ModelInfoGraphBuilder<T, C> modelInfoGraphBuilder, MPackageInfo packageInfo) {
        Validate.notNull(modelInfoGraphBuilder);
        Validate.notNull((Object)packageInfo);
        this.modelInfoGraphBuilder = modelInfoGraphBuilder;
        this.packageInfo = packageInfo;
    }

    public TypeInfoVertex<T, C> visitBuiltinLeafInfo(MBuiltinLeafInfo<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(null, info);
        this.addInfoVertex(typeVertex);
        return typeVertex;
    }

    public TypeInfoVertex<T, C> visitWildcardTypeInfo(MWildcardTypeInfo<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(null, info);
        this.addInfoVertex(typeVertex);
        return typeVertex;
    }

    public TypeInfoVertex<T, C> visitID(MID<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(null, info);
        if (this.addInfoVertex(typeVertex)) {
            TypeInfoVertex<T, C> valueTypeVertex = this.modelInfoGraphBuilder.typeInfo(this.packageInfo, info.getValueTypeInfo());
            this.modelInfoGraphBuilder.addHardDependency(typeVertex, valueTypeVertex);
        }
        return typeVertex;
    }

    public TypeInfoVertex<T, C> visitIDREF(MIDREF<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(null, info);
        if (this.addInfoVertex(typeVertex)) {
            TypeInfoVertex<T, C> valueTypeVertex = this.modelInfoGraphBuilder.typeInfo(this.packageInfo, info.getValueTypeInfo());
            this.modelInfoGraphBuilder.addHardDependency(typeVertex, valueTypeVertex);
        }
        return typeVertex;
    }

    public TypeInfoVertex<T, C> visitIDREFS(MIDREFS<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(null, info);
        if (this.addInfoVertex(typeVertex)) {
            TypeInfoVertex<T, C> valueTypeVertex = this.modelInfoGraphBuilder.typeInfo(this.packageInfo, info.getItemTypeInfo());
            this.modelInfoGraphBuilder.addHardDependency(typeVertex, valueTypeVertex);
        }
        return typeVertex;
    }

    public TypeInfoVertex<T, C> visitList(MList<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(null, info);
        if (this.addInfoVertex(typeVertex)) {
            TypeInfoVertex<T, C> itemTypeVertex = this.modelInfoGraphBuilder.typeInfo(this.packageInfo, info.getItemTypeInfo());
            this.modelInfoGraphBuilder.addHardDependency(typeVertex, itemTypeVertex);
        }
        return typeVertex;
    }

    public TypeInfoVertex<T, C> visitEnumLeafInfo(MEnumLeafInfo<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(info.getPackageInfo(), info);
        if (this.addInfoVertex(typeVertex)) {
            if (info.getBaseTypeInfo() != null) {
                TypeInfoVertex<T, C> baseTypeVertex = this.modelInfoGraphBuilder.typeInfo(info.getPackageInfo(), info.getBaseTypeInfo());
                this.modelInfoGraphBuilder.addHardDependency(typeVertex, baseTypeVertex);
            }
            PackageInfoVertex<T, C> packageInfoVertex = this.modelInfoGraphBuilder.packageInfo(info.getPackageInfo());
            this.modelInfoGraphBuilder.addSoftDependency(packageInfoVertex, typeVertex);
        }
        return typeVertex;
    }

    public TypeInfoVertex<T, C> visitClassRef(MClassRef<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(info.getPackageInfo(), info);
        if (this.addInfoVertex(typeVertex)) {
            PackageInfoVertex<T, C> packageInfoVertex = this.modelInfoGraphBuilder.packageInfo(info.getPackageInfo());
            this.modelInfoGraphBuilder.addSoftDependency(packageInfoVertex, typeVertex);
        }
        return typeVertex;
    }

    public TypeInfoVertex<T, C> visitClassInfo(MClassInfo<T, C> info) {
        TypeInfoVertex<T, C> typeVertex = new TypeInfoVertex<T, C>(info.getPackageInfo(), info);
        if (this.addInfoVertex(typeVertex)) {
            if (info.getBaseTypeInfo() != null) {
                TypeInfoVertex<T, C> baseTypeVertex = this.modelInfoGraphBuilder.typeInfo(info.getPackageInfo(), (MTypeInfo<T, C>)info.getBaseTypeInfo());
                this.modelInfoGraphBuilder.addHardDependency(typeVertex, baseTypeVertex);
            }
            for (MPropertyInfo propertyInfo : info.getProperties()) {
                PropertyInfoVertex<T, C> propertyVertex = this.modelInfoGraphBuilder.propertyInfo(propertyInfo);
                this.modelInfoGraphBuilder.addSoftDependency(typeVertex, propertyVertex);
            }
            PackageInfoVertex<T, C> packageInfoVertex = this.modelInfoGraphBuilder.packageInfo(info.getPackageInfo());
            this.modelInfoGraphBuilder.addSoftDependency(packageInfoVertex, typeVertex);
        }
        return typeVertex;
    }

    private boolean addInfoVertex(InfoVertex<T, C> vertex) {
        return this.modelInfoGraphBuilder.addInfoVertex(vertex);
    }
}

