/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.writer;

import java.io.IOException;
import java.util.List;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.operator.impl.AssignmentOperator;
import org.hisrc.jscm.codemodel.statement.JSBlock;
import org.hisrc.jscm.codemodel.statement.JSBreakStatement;
import org.hisrc.jscm.codemodel.statement.JSContinueStatement;
import org.hisrc.jscm.codemodel.statement.JSDebuggerStatement;
import org.hisrc.jscm.codemodel.statement.JSDoWhileStatement;
import org.hisrc.jscm.codemodel.statement.JSEmptyStatement;
import org.hisrc.jscm.codemodel.statement.JSExpressionStatement;
import org.hisrc.jscm.codemodel.statement.JSForInStatement;
import org.hisrc.jscm.codemodel.statement.JSForStatement;
import org.hisrc.jscm.codemodel.statement.JSForVarInStatement;
import org.hisrc.jscm.codemodel.statement.JSForVarStatement;
import org.hisrc.jscm.codemodel.statement.JSIfStatement;
import org.hisrc.jscm.codemodel.statement.JSLabelledStatement;
import org.hisrc.jscm.codemodel.statement.JSReturnStatement;
import org.hisrc.jscm.codemodel.statement.JSStatement;
import org.hisrc.jscm.codemodel.statement.JSStatementVisitor;
import org.hisrc.jscm.codemodel.statement.JSSwitchStatement;
import org.hisrc.jscm.codemodel.statement.JSThrowStatement;
import org.hisrc.jscm.codemodel.statement.JSTryStatement;
import org.hisrc.jscm.codemodel.statement.JSVariableDeclaration;
import org.hisrc.jscm.codemodel.statement.JSVariableStatement;
import org.hisrc.jscm.codemodel.statement.JSWhileStatement;
import org.hisrc.jscm.codemodel.statement.JSWithStatement;
import org.hisrc.jscm.codemodel.writer.CodeWriter;

public class StatementWriter
implements JSStatementVisitor<CodeWriter, IOException> {
    private final CodeWriter f;

    public StatementWriter(CodeWriter formatter) {
        Validate.notNull(formatter);
        this.f = formatter;
    }

    @Override
    public CodeWriter visitBlock(JSBlock value) throws IOException {
        this.f.openCurlyBracket();
        this.f.lineTerminator();
        CodeWriter fi = this.f.indented();
        List<JSStatement> statements = value.getStatements();
        for (int index = 0; index < statements.size(); ++index) {
            JSStatement statement = statements.get(index);
            fi.statement(statement);
            fi.lineTerminator();
        }
        this.f.closeCurlyBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitBreak(JSBreakStatement value) throws IOException {
        this.f.keyword("break");
        if (value.getLabel() != null) {
            this.f.whiteSpace();
            this.f.identifier(value.getLabel().getName());
        }
        this.f.semicolon();
        return this.f;
    }

    @Override
    public CodeWriter visitContinue(JSContinueStatement value) throws IOException {
        this.f.keyword("continue");
        if (value.getLabel() != null) {
            this.f.whiteSpace();
            this.f.identifier(value.getLabel().getName());
        }
        this.f.semicolon();
        return this.f;
    }

    @Override
    public CodeWriter visitDebugger(JSDebuggerStatement value) throws IOException {
        this.f.keyword("debugger");
        this.f.semicolon();
        return this.f;
    }

    @Override
    public CodeWriter visitDoWhile(JSDoWhileStatement value) throws IOException {
        this.f.keyword("do");
        this.f.block(value.getStatement());
        this.f.lineTerminator().keyword("while").whiteSpace();
        this.f.openRoundBracket();
        this.f.expression(value.getExpression());
        this.f.closeRoundBracket();
        this.f.semicolon();
        return this.f;
    }

    @Override
    public CodeWriter visitEmpty(JSEmptyStatement value) throws IOException {
        this.f.semicolon();
        return this.f;
    }

    @Override
    public CodeWriter visitExpression(JSExpressionStatement value) throws IOException {
        this.f.expression(value.getExpression());
        this.f.semicolon();
        return this.f;
    }

    @Override
    public CodeWriter visitFor(JSForStatement value) throws IOException {
        this.f.keyword("for");
        this.f.openRoundBracket();
        if (value.getExpression() != null) {
            this.f.expression(value.getExpression());
        }
        this.f.semicolon();
        if (value.getTest() != null) {
            this.f.whiteSpace();
            this.f.expression(value.getTest());
        }
        this.f.semicolon();
        if (value.getUpdate() != null) {
            this.f.whiteSpace();
            this.f.expression(value.getUpdate());
        }
        this.f.closeRoundBracket().whiteSpace();
        this.f.block(value.getStatement());
        return this.f;
    }

    @Override
    public CodeWriter visitForIn(JSForInStatement value) throws IOException {
        this.f.keyword("for").whiteSpace();
        this.f.openRoundBracket();
        this.f.expression(value.getExpression());
        this.f.whiteSpace().keyword("in").whiteSpace();
        this.f.expression(value.getIn());
        this.f.closeRoundBracket();
        this.f.whiteSpace();
        this.f.block(value.getStatement());
        return this.f;
    }

    @Override
    public CodeWriter visitForVar(JSForVarStatement value) throws IOException {
        this.f.keyword("for").whiteSpace();
        this.f.openRoundBracket();
        this.visitVariableDeclarations(value.getVariableDeclarations());
        this.f.semicolon();
        if (value.getTest() != null) {
            this.f.whiteSpace();
            this.f.expression(value.getTest());
        }
        this.f.semicolon();
        if (value.getUpdate() != null) {
            this.f.whiteSpace();
            this.f.expression(value.getUpdate());
        }
        this.f.closeRoundBracket().whiteSpace();
        this.f.block(value.getStatement());
        return this.f;
    }

    @Override
    public CodeWriter visitForVarIn(JSForVarInStatement value) throws IOException {
        this.f.keyword("for").whiteSpace();
        this.f.openRoundBracket();
        this.f.keyword("var").whiteSpace();
        this.f.identifier(value.getVariable().getName());
        this.f.whiteSpace().keyword("in").whiteSpace();
        this.f.expression(value.getIn());
        this.f.closeRoundBracket().whiteSpace();
        this.f.block(value.getStatement());
        return this.f;
    }

    @Override
    public CodeWriter visitIf(JSIfStatement value) throws IOException {
        this.f.keyword("if").whiteSpace();
        this.f.openRoundBracket();
        this.f.indented().expression(value.getIf());
        this.f.closeRoundBracket();
        this.f.whiteSpace();
        this.f.block(value.getThen());
        if (value.getElse() != null) {
            this.f.lineTerminator().keyword("else").whiteSpace();
            this.f.block(value.getElse());
        }
        return this.f;
    }

    @Override
    public CodeWriter visitLabelled(JSLabelledStatement value) throws IOException {
        this.f.identifier(value.getLabel().getName());
        this.f.colon().whiteSpace();
        this.f.statement(value.getStatement());
        return this.f;
    }

    @Override
    public CodeWriter visitReturn(JSReturnStatement value) throws IOException {
        this.f.keyword("return");
        if (value.getReturn() != null) {
            this.f.whiteSpace();
            this.f.expression(value.getReturn());
        }
        this.f.semicolon();
        return this.f;
    }

    @Override
    public CodeWriter visitSwitch(JSSwitchStatement value) throws IOException {
        JSStatement statement;
        int index;
        List<JSStatement> statements;
        this.f.keyword("switch").whiteSpace();
        this.f.openRoundBracket();
        this.f.indented().expression(value.getExpression());
        this.f.closeRoundBracket();
        this.f.whiteSpace();
        this.f.openCurlyBracket();
        this.f.lineTerminator();
        CodeWriter fi = this.f.indented();
        for (JSSwitchStatement.JSCaseClause caseClause : value.getFirstCaseClauses()) {
            fi.keyword("case").whiteSpace();
            fi.indented().expression(caseClause.getExpression());
            fi.colon().whiteSpace();
            statements = caseClause.getStatements();
            for (index = 0; index < statements.size(); ++index) {
                statement = statements.get(index);
                fi.block(statement);
            }
            fi.lineTerminator();
        }
        if (value.getDefaultClause() != null) {
            fi.keyword("default");
            fi.colon().whiteSpace();
            List<JSStatement> statements2 = value.getDefaultClause().getStatements();
            for (int index2 = 0; index2 < statements2.size(); ++index2) {
                JSStatement statement2 = statements2.get(index2);
                fi.block(statement2);
            }
            fi.lineTerminator();
        }
        for (JSSwitchStatement.JSCaseClause caseClause : value.getSecondCaseClauses()) {
            fi.keyword("case").whiteSpace();
            this.f.expression(caseClause.getExpression());
            fi.colon().whiteSpace();
            statements = caseClause.getStatements();
            for (index = 0; index < statements.size(); ++index) {
                statement = statements.get(index);
                fi.block(statement);
            }
            fi.lineTerminator();
        }
        this.f.closeCurlyBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitThrow(JSThrowStatement value) throws IOException {
        return this.f.keyword("throw").whiteSpace().expression(value.getExpression()).semicolon();
    }

    @Override
    public CodeWriter visitTry(JSTryStatement value) throws IOException {
        this.f.keyword("try").whiteSpace();
        this.f.statement(value.getBody());
        if (value.getCatch() != null) {
            this.f.lineTerminator();
            this.f.keyword("catch").whiteSpace();
            this.f.openRoundBracket();
            this.f.expression(value.getException());
            this.f.closeRoundBracket().whiteSpace();
            this.f.statement(value.getCatch());
        }
        if (value.getFinally() != null) {
            this.f.lineTerminator();
            this.f.keyword("finally").whiteSpace();
            this.f.statement(value.getFinally());
        }
        return this.f;
    }

    @Override
    public CodeWriter visitVariable(JSVariableStatement value) throws IOException {
        List<JSVariableDeclaration> variableDeclarations = value.getVariableDeclarations();
        return this.visitVariableDeclarations(variableDeclarations);
    }

    private CodeWriter visitVariableDeclarations(List<JSVariableDeclaration> variableDeclarations) throws IOException {
        this.f.keyword("var").whiteSpace();
        for (int index = 0; index < variableDeclarations.size(); ++index) {
            if (index > 0) {
                this.f.comma().whiteSpace();
            }
            JSVariableDeclaration variableDeclaration = variableDeclarations.get(index);
            this.f.identifier(variableDeclaration.getVariable().getName());
            if (variableDeclaration.getExpression() == null) continue;
            this.f.operator(AssignmentOperator.ASSIGN);
            this.f.expression(variableDeclaration.getExpression());
        }
        this.f.semicolon();
        return this.f;
    }

    @Override
    public CodeWriter visitWhile(JSWhileStatement value) throws IOException {
        this.f.keyword("while").whiteSpace();
        this.f.openRoundBracket();
        this.f.indented().expression(value.getExpression());
        this.f.closeRoundBracket();
        this.f.block(value.getStatement());
        return this.f;
    }

    @Override
    public CodeWriter visitWith(JSWithStatement value) throws IOException {
        this.f.keyword("with").whiteSpace();
        this.f.openRoundBracket();
        this.f.indented().expression(value.getWith());
        this.f.closeRoundBracket().whiteSpace();
        this.f.block(value.getStatement());
        return this.f;
    }
}

