/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.writer;

import java.io.IOException;
import java.util.List;
import org.hisrc.jscm.codemodel.JSFunctionDeclaration;
import org.hisrc.jscm.codemodel.JSSourceElement;
import org.hisrc.jscm.codemodel.JSSourceElementVisitor;
import org.hisrc.jscm.codemodel.expression.JSVariable;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.statement.JSStatement;
import org.hisrc.jscm.codemodel.writer.CodeWriter;

public class SourceElementWriter
implements JSSourceElementVisitor<CodeWriter, IOException> {
    private final CodeWriter f;

    public SourceElementWriter(CodeWriter formatter) {
        Validate.notNull(formatter);
        this.f = formatter;
    }

    @Override
    public CodeWriter visitFunctionDeclaration(JSFunctionDeclaration value) throws IOException {
        this.f.keyword("function").whiteSpace();
        this.f.identifier(value.getName());
        this.f.openRoundBracket();
        for (int index = 0; index < value.getParameters().size(); ++index) {
            JSVariable parameter = value.getParameters().get(index);
            if (index > 0) {
                this.f.comma().whiteSpace();
            }
            this.f.identifier(parameter.getName());
        }
        this.f.closeRoundBracket();
        this.f.whiteSpace();
        this.f.openCurlyBracket().lineTerminator();
        CodeWriter fi = this.f.indented();
        List<JSSourceElement> sourceElements = value.getBody().getSourceElements();
        for (int index = 0; index < sourceElements.size(); ++index) {
            JSSourceElement sourceElement = sourceElements.get(index);
            fi.sourceElement(sourceElement);
            fi.lineTerminator();
        }
        this.f.closeCurlyBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitStatement(JSStatement value) throws IOException {
        return this.f.statement(value);
    }
}

