/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.writer;

import java.io.IOException;
import java.util.List;
import org.hisrc.jscm.codemodel.JSProgram;
import org.hisrc.jscm.codemodel.JSProgramVisitor;
import org.hisrc.jscm.codemodel.JSSourceElement;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.writer.CodeWriter;

public class ProgramWriter
implements JSProgramVisitor<CodeWriter, IOException> {
    private final CodeWriter f;

    public ProgramWriter(CodeWriter formatter) {
        Validate.notNull(formatter);
        this.f = formatter;
    }

    @Override
    public CodeWriter visitProgram(JSProgram value) throws IOException {
        Validate.notNull(value);
        List<JSSourceElement> sourceElements = value.getSourceElements();
        int size = sourceElements.size();
        for (int index = 0; index < size; ++index) {
            if (index > 0) {
                this.f.lineTerminator();
            }
            JSSourceElement sourceElement = sourceElements.get(index);
            this.f.sourceElement(sourceElement);
        }
        return this.f;
    }
}

