/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.writer;

import java.io.IOException;
import java.util.List;
import org.hisrc.jscm.codemodel.JSPropertyName;
import org.hisrc.jscm.codemodel.JSSourceElement;
import org.hisrc.jscm.codemodel.expression.JSAdditiveExpression;
import org.hisrc.jscm.codemodel.expression.JSArrayLiteral;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSBinaryExpression;
import org.hisrc.jscm.codemodel.expression.JSBitwiseANDExpression;
import org.hisrc.jscm.codemodel.expression.JSBitwiseORExpression;
import org.hisrc.jscm.codemodel.expression.JSBitwiseXORExpression;
import org.hisrc.jscm.codemodel.expression.JSCallExpression;
import org.hisrc.jscm.codemodel.expression.JSConditionalExpression;
import org.hisrc.jscm.codemodel.expression.JSEqualityExpression;
import org.hisrc.jscm.codemodel.expression.JSExpression;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSFunctionExpression;
import org.hisrc.jscm.codemodel.expression.JSGlobalVariable;
import org.hisrc.jscm.codemodel.expression.JSInvocationExpression;
import org.hisrc.jscm.codemodel.expression.JSLogicalANDExpression;
import org.hisrc.jscm.codemodel.expression.JSLogicalORExpression;
import org.hisrc.jscm.codemodel.expression.JSMemberExpression;
import org.hisrc.jscm.codemodel.expression.JSMultiplicativeExpression;
import org.hisrc.jscm.codemodel.expression.JSNewExpression;
import org.hisrc.jscm.codemodel.expression.JSObjectLiteral;
import org.hisrc.jscm.codemodel.expression.JSPostfixExpression;
import org.hisrc.jscm.codemodel.expression.JSPrimaryExpression;
import org.hisrc.jscm.codemodel.expression.JSRelationalExpression;
import org.hisrc.jscm.codemodel.expression.JSShiftExpression;
import org.hisrc.jscm.codemodel.expression.JSThis;
import org.hisrc.jscm.codemodel.expression.JSUnaryExpression;
import org.hisrc.jscm.codemodel.expression.JSVariable;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.literal.JSLiteral;
import org.hisrc.jscm.codemodel.writer.CodeWriter;

public class ExpressionWriter
implements JSExpressionVisitor<CodeWriter, IOException> {
    private final CodeWriter f;

    public ExpressionWriter(CodeWriter formatter) {
        Validate.notNull(formatter);
        this.f = formatter;
    }

    @Override
    public CodeWriter visitThis(JSThis value) throws IOException {
        this.f.keyword("this");
        return this.f;
    }

    @Override
    public CodeWriter visitVariable(JSVariable value) throws IOException {
        this.f.identifier(value.getName());
        return this.f;
    }

    @Override
    public CodeWriter visitGlobalVariable(JSGlobalVariable value) throws IOException {
        this.f.identifier(value.getName());
        return this.f;
    }

    @Override
    public CodeWriter visitLiteral(JSLiteral value) throws IOException {
        return this.f.literal(value);
    }

    @Override
    public CodeWriter visitArrayLiteral(JSArrayLiteral value) throws IOException {
        this.f.openSquareBracket();
        CodeWriter fi = this.f.indented();
        List<JSAssignmentExpression> elements = value.getElements();
        int elementsCount = elements.size();
        for (int index = 0; index < elementsCount; ++index) {
            boolean first = index == 0;
            JSAssignmentExpression element = elements.get(index);
            if (!first) {
                fi.comma().whiteSpace();
            }
            fi.expression(element);
        }
        this.f.closeSquareBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitObjectLiteral(JSObjectLiteral value) throws IOException {
        this.f.openCurlyBracket();
        List<JSObjectLiteral.JSPropertyAssignment> propertyAssignments = value.getPropertyAssignments();
        if (!propertyAssignments.isEmpty()) {
            this.f.lineTerminator();
            CodeWriter fi = this.f.indented();
            for (int index = 0; index < propertyAssignments.size(); ++index) {
                if (index > 0) {
                    fi.comma().lineTerminator();
                }
                JSObjectLiteral.JSPropertyAssignment propertyAssignment = propertyAssignments.get(index);
                JSPropertyName propertyName = propertyAssignment.getKey();
                JSAssignmentExpression propertyValue = propertyAssignment.getValue();
                fi.propertyName(propertyName).colon().whiteSpace().expression(propertyValue);
            }
            this.f.lineTerminator();
        }
        this.f.closeCurlyBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitBrackets(JSPrimaryExpression.Brackets value) throws IOException {
        this.f.openRoundBracket();
        this.f.indented().expression(value.getBase());
        this.f.closeRoundBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitFunction(JSFunctionExpression.Function value) throws IOException {
        this.f.keyword("function").whiteSpace();
        if (value.getName() != null) {
            this.f.identifier(value.getName());
        }
        this.f.openRoundBracket();
        for (int index = 0; index < value.getParameters().size(); ++index) {
            JSVariable parameter = value.getParameters().get(index);
            if (index > 0) {
                this.f.comma().whiteSpace();
            }
            this.f.identifier(parameter.getName());
        }
        this.f.closeRoundBracket().whiteSpace();
        this.f.openCurlyBracket().lineTerminator();
        CodeWriter fi = this.f.indented();
        List<JSSourceElement> sourceElements = value.getBody().getSourceElements();
        for (int index = 0; index < sourceElements.size(); ++index) {
            JSSourceElement sourceElement = sourceElements.get(index);
            fi.sourceElement(sourceElement);
            fi.lineTerminator();
        }
        this.f.closeCurlyBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitMemberElement(JSMemberExpression.MemberElement value) throws IOException {
        this.f.expression(value.getBase());
        this.f.openSquareBracket();
        this.f.indented().expression(value.getIndex());
        this.f.closeSquareBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitMemberProperty(JSMemberExpression.MemberProperty value) throws IOException {
        this.f.expression(value.getBase());
        this.f.dot();
        this.f.indented().propertyName(value.getName());
        return this.f;
    }

    @Override
    public CodeWriter visitMemberNew(JSMemberExpression.MemberNew value) throws IOException {
        this.f.keyword("new").whiteSpace();
        return this.visitInvocation(value);
    }

    private CodeWriter visitInvocation(JSInvocationExpression value) throws IOException {
        this.f.expression(value.getBase());
        this.f.openRoundBracket();
        CodeWriter fi = this.f.indented();
        List<JSAssignmentExpression> args = value.getArgs();
        for (int index = 0; index < args.size(); ++index) {
            if (index > 0) {
                fi.comma().whiteSpace();
            }
            JSExpression arg = args.get(index);
            fi.expression(arg);
        }
        this.f.closeRoundBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitMemberCall(JSCallExpression.MemberCall value) throws IOException {
        return this.visitInvocation(value);
    }

    @Override
    public CodeWriter visitNew(JSNewExpression.New value) throws IOException {
        this.f.keyword("new").whiteSpace();
        this.f.expression(value.getBase());
        return this.f;
    }

    @Override
    public CodeWriter visitCallArgs(JSCallExpression.CallArgs value) throws IOException {
        return this.visitInvocation(value);
    }

    @Override
    public CodeWriter visitCallElement(JSCallExpression.CallElement value) throws IOException {
        this.f.expression(value.getBase());
        this.f.openSquareBracket();
        this.f.indented().expression(value.getIndex());
        this.f.closeSquareBracket();
        return this.f;
    }

    @Override
    public CodeWriter visitCallProperty(JSCallExpression.CallProperty value) throws IOException {
        this.f.expression(value.getBase());
        this.f.dot();
        this.f.indented().propertyName(value.getName());
        return this.f;
    }

    @Override
    public CodeWriter visitPostfix(JSPostfixExpression.Postfix value) throws IOException {
        this.f.expression(value.getBase());
        this.f.operator(value.getOperator());
        return this.f;
    }

    @Override
    public CodeWriter visitUnary(JSUnaryExpression.Unary value) throws IOException {
        this.f.operator(value.getOperator());
        this.f.expression(value.getBase());
        return this.f;
    }

    @Override
    public CodeWriter visitMultiplicative(JSMultiplicativeExpression.Multiplicative value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitAdditive(JSAdditiveExpression.Additive value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitShift(JSShiftExpression.Shift value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitRelational(JSRelationalExpression.Relational value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitEquality(JSEqualityExpression.Equality value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitBand(JSBitwiseANDExpression.Band value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitXor(JSBitwiseXORExpression.Xor value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitBor(JSBitwiseORExpression.Bor value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitAnd(JSLogicalANDExpression.And value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitOr(JSLogicalORExpression.Or value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitConditional(JSConditionalExpression.Conditional value) throws IOException {
        this.f.expression(value.getCondition());
        this.f.whiteSpace();
        this.f.questionMark();
        this.f.whiteSpace();
        this.f.indented().expression(value.getIfTrue());
        this.f.whiteSpace();
        this.f.colon();
        this.f.whiteSpace();
        this.f.indented().expression(value.getIfFalse());
        return this.f;
    }

    @Override
    public CodeWriter visitAssignment(JSAssignmentExpression.Assignment value) throws IOException {
        return this.visitBinaryExpression(value);
    }

    @Override
    public CodeWriter visitComma(JSExpression.Comma value) throws IOException {
        this.f.expression(value.getLeft());
        this.f.comma().whiteSpace();
        this.f.indented().expression(value.getRight());
        return this.f;
    }

    private CodeWriter visitBinaryExpression(JSBinaryExpression value) throws IOException {
        this.f.expression(value.getLeft());
        this.f.operator(value.getOperator());
        this.f.expression(value.getRight());
        return this.f;
    }
}

