/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.statement.impl;

import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSVariable;
import org.hisrc.jscm.codemodel.expression.impl.VariableImpl;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.statement.JSBlock;
import org.hisrc.jscm.codemodel.statement.JSStatementVisitor;
import org.hisrc.jscm.codemodel.statement.JSTryStatement;
import org.hisrc.jscm.codemodel.statement.impl.BlockImpl;
import org.hisrc.jscm.codemodel.statement.impl.StatementImpl;

public class TryStatementImpl
extends StatementImpl
implements JSTryStatement {
    private final JSBlock _try;
    private final JSVariable exception;
    private final JSBlock _catch;
    private final JSBlock _finally;

    public TryStatementImpl(JSCodeModel codeModel, String exception, boolean _finally) {
        super(codeModel);
        if (!_finally) {
            Validate.notNull(exception);
        }
        this._try = new BlockImpl(codeModel);
        if (exception == null) {
            this.exception = null;
            this._catch = null;
        } else {
            this.exception = new VariableImpl(codeModel, exception);
            this._catch = new BlockImpl(codeModel);
        }
        this._finally = _finally ? new BlockImpl(codeModel) : null;
    }

    @Override
    public JSBlock getBody() {
        return this._try;
    }

    @Override
    public JSBlock getCatch() {
        return this._catch;
    }

    @Override
    public JSBlock getFinally() {
        return this._finally;
    }

    @Override
    public JSVariable getException() {
        return this.exception;
    }

    @Override
    public <V, E extends Exception> V acceptStatementVisitor(JSStatementVisitor<V, E> visitor) throws E {
        return visitor.visitTry(this);
    }
}

