/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.statement.impl;

import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSExpression;
import org.hisrc.jscm.codemodel.expression.JSLeftHandSideExpression;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.statement.JSBlock;
import org.hisrc.jscm.codemodel.statement.JSBreakStatement;
import org.hisrc.jscm.codemodel.statement.JSContinueStatement;
import org.hisrc.jscm.codemodel.statement.JSDebuggerStatement;
import org.hisrc.jscm.codemodel.statement.JSDoWhileStatement;
import org.hisrc.jscm.codemodel.statement.JSEmptyStatement;
import org.hisrc.jscm.codemodel.statement.JSExpressionStatement;
import org.hisrc.jscm.codemodel.statement.JSForInStatement;
import org.hisrc.jscm.codemodel.statement.JSForStatement;
import org.hisrc.jscm.codemodel.statement.JSForVarInStatement;
import org.hisrc.jscm.codemodel.statement.JSForVarStatement;
import org.hisrc.jscm.codemodel.statement.JSIfStatement;
import org.hisrc.jscm.codemodel.statement.JSLabelledStatement;
import org.hisrc.jscm.codemodel.statement.JSReturnStatement;
import org.hisrc.jscm.codemodel.statement.JSStatement;
import org.hisrc.jscm.codemodel.statement.JSStatementGenerator;
import org.hisrc.jscm.codemodel.statement.JSSwitchStatement;
import org.hisrc.jscm.codemodel.statement.JSThrowStatement;
import org.hisrc.jscm.codemodel.statement.JSTryStatement;
import org.hisrc.jscm.codemodel.statement.JSVariableStatement;
import org.hisrc.jscm.codemodel.statement.JSWhileStatement;
import org.hisrc.jscm.codemodel.statement.JSWithStatement;
import org.hisrc.jscm.codemodel.statement.impl.BlockImpl;
import org.hisrc.jscm.codemodel.statement.impl.BreakStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.ContinueStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.DebuggerStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.DoWhileStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.EmptyStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.ExpressionStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.ForInStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.ForStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.ForVarInStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.ForVarStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.IfStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.LabelledStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.ReturnStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.SwitchStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.ThrowStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.TryStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.VariableStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.WhileStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.WithStatementImpl;

public abstract class StatementGeneratorImpl
implements JSStatementGenerator {
    private final JSCodeModel codeModel;

    public StatementGeneratorImpl(JSCodeModel codeModel) {
        Validate.notNull(codeModel);
        this.codeModel = codeModel;
    }

    public JSCodeModel getCodeModel() {
        return this.codeModel;
    }

    protected abstract <S extends JSStatement> S add(S var1);

    @Override
    public JSBlock block() {
        return this.add(new BlockImpl(this.getCodeModel()));
    }

    @Override
    public JSVariableStatement var(String name) {
        return this.add(new VariableStatementImpl(this.getCodeModel(), name));
    }

    @Override
    public JSVariableStatement var(String name, JSAssignmentExpression expression) {
        return this.add(new VariableStatementImpl(this.getCodeModel(), name, expression));
    }

    @Override
    public JSEmptyStatement empty() {
        return this.add(new EmptyStatementImpl(this.getCodeModel()));
    }

    @Override
    public JSExpressionStatement expression(JSExpression expression) {
        return this.add(new ExpressionStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSIfStatement _if(JSExpression expression) {
        return this.add(new IfStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSDoWhileStatement doWhile(JSExpression expression) {
        return this.add(new DoWhileStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSWhileStatement _while(JSExpression expression) {
        return this.add(new WhileStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSForStatement _for() {
        return this.add(new ForStatementImpl(this.getCodeModel()));
    }

    @Override
    public JSForStatement _for(JSExpression expression) {
        return this.add(new ForStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSForInStatement forIn(JSLeftHandSideExpression expression, JSExpression _in) {
        return this.add(new ForInStatementImpl(this.getCodeModel(), expression, _in));
    }

    @Override
    public JSForVarStatement forVar(String name) {
        return this.add(new ForVarStatementImpl(this.getCodeModel(), name));
    }

    @Override
    public JSForVarStatement forVar(String name, JSAssignmentExpression expression) {
        return this.add(new ForVarStatementImpl(this.getCodeModel(), name, expression));
    }

    @Override
    public JSForVarInStatement forVarIn(String name, JSExpression _in) {
        return this.add(new ForVarInStatementImpl(this.getCodeModel(), name, _in));
    }

    @Override
    public JSContinueStatement _continue() {
        return this.add(new ContinueStatementImpl(this.getCodeModel()));
    }

    @Override
    public JSContinueStatement _continue(JSLabelledStatement.JSLabel label) {
        return this.add(new ContinueStatementImpl(this.getCodeModel(), label));
    }

    @Override
    public JSBreakStatement _break() {
        return this.add(new BreakStatementImpl(this.getCodeModel()));
    }

    @Override
    public JSBreakStatement _break(JSLabelledStatement.JSLabel label) {
        return this.add(new BreakStatementImpl(this.getCodeModel(), label));
    }

    @Override
    public JSReturnStatement _return() {
        return this.add(new ReturnStatementImpl(this.getCodeModel()));
    }

    @Override
    public JSReturnStatement _return(JSExpression expression) {
        return this.add(new ReturnStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSWithStatement with(JSExpression expression) {
        return this.add(new WithStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSLabelledStatement label(String name) {
        return this.add(new LabelledStatementImpl(this.getCodeModel(), name));
    }

    @Override
    public JSSwitchStatement _switch(JSExpression expression) {
        return this.add(new SwitchStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSThrowStatement _throw(JSExpression expression) {
        return this.add(new ThrowStatementImpl(this.getCodeModel(), expression));
    }

    @Override
    public JSTryStatement tryCatch(String expression) {
        return this.add(new TryStatementImpl(this.getCodeModel(), expression, false));
    }

    @Override
    public JSTryStatement tryFinally() {
        return this.add(new TryStatementImpl(this.getCodeModel(), null, true));
    }

    @Override
    public JSTryStatement tryCatchFinally(String expression) {
        return this.add(new TryStatementImpl(this.getCodeModel(), expression, true));
    }

    @Override
    public JSDebuggerStatement debugger() {
        return this.add(new DebuggerStatementImpl(this.getCodeModel()));
    }
}

