/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.JSFunctionBody;
import org.hisrc.jscm.codemodel.JSFunctionDeclaration;
import org.hisrc.jscm.codemodel.JSSourceElementVisitor;
import org.hisrc.jscm.codemodel.expression.JSPrimaryExpression;
import org.hisrc.jscm.codemodel.expression.JSVariable;
import org.hisrc.jscm.codemodel.expression.impl.VariableImpl;
import org.hisrc.jscm.codemodel.impl.FunctionBodyImpl;
import org.hisrc.jscm.codemodel.lang.Validate;

public class FunctionDeclarationImpl
implements JSFunctionDeclaration {
    private final JSCodeModel codeModel;
    private final String name;
    private final JSPrimaryExpression functionExpression;
    private final List<JSVariable> parameters = new ArrayList<JSVariable>();
    private final List<JSVariable> unmodifiableParameters = Collections.unmodifiableList(this.parameters);
    private final JSFunctionBody body;

    public FunctionDeclarationImpl(JSCodeModel codeModel, String name) {
        Validate.notNull(codeModel);
        Validate.notNull(name);
        this.codeModel = codeModel;
        this.name = name;
        this.functionExpression = new VariableImpl(codeModel, name);
        this.body = new FunctionBodyImpl(codeModel);
    }

    public JSCodeModel getCodeModel() {
        return this.codeModel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JSPrimaryExpression getFunctionExpression() {
        return this.functionExpression;
    }

    @Override
    public JSFunctionBody getBody() {
        return this.body;
    }

    @Override
    public List<JSVariable> getParameters() {
        return this.unmodifiableParameters;
    }

    @Override
    public JSVariable parameter(String name) {
        Validate.notNull(name);
        VariableImpl parameter = new VariableImpl(this.getCodeModel(), name);
        this.parameters.add(parameter);
        return parameter;
    }

    @Override
    public <V, E extends Exception> V acceptSourceElementVisitor(JSSourceElementVisitor<V, E> visitor) throws E {
        return visitor.visitFunctionDeclaration(this);
    }
}

