/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.expression.impl;

import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSAdditiveExpression;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSShiftExpression;
import org.hisrc.jscm.codemodel.expression.impl.RelationalExpressionImpl;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.operator.impl.ShiftOperator;

public abstract class ShiftExpressionImpl
extends RelationalExpressionImpl
implements JSShiftExpression {
    public ShiftExpressionImpl(JSCodeModel codeModel) {
        super(codeModel);
    }

    @Override
    public JSShiftExpression.Shift shl(JSAdditiveExpression value) {
        return new ShiftImpl(this.getCodeModel(), this, value, ShiftOperator.SHL);
    }

    @Override
    public JSShiftExpression.Shift shr(JSAdditiveExpression value) {
        return new ShiftImpl(this.getCodeModel(), this, value, ShiftOperator.SHR);
    }

    @Override
    public JSShiftExpression.Shift shrz(JSAdditiveExpression value) {
        return new ShiftImpl(this.getCodeModel(), this, value, ShiftOperator.SHRZ);
    }

    public static class ShiftImpl
    extends ShiftExpressionImpl
    implements JSShiftExpression.Shift {
        private final JSShiftExpression left;
        private final JSAdditiveExpression right;
        private final ShiftOperator operator;

        public ShiftImpl(JSCodeModel codeModel, JSShiftExpression left, JSAdditiveExpression right, ShiftOperator operator) {
            super(codeModel);
            Validate.notNull(left);
            Validate.notNull(right);
            Validate.notNull(operator);
            this.left = left;
            this.right = right;
            this.operator = operator;
        }

        @Override
        public JSShiftExpression getLeft() {
            return this.left;
        }

        @Override
        public JSAdditiveExpression getRight() {
            return this.right;
        }

        @Override
        public ShiftOperator getOperator() {
            return this.operator;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitShift(this);
        }
    }
}

