/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.expression.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.JSPropertyName;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSObjectLiteral;
import org.hisrc.jscm.codemodel.expression.impl.PrimaryExpressionImpl;
import org.hisrc.jscm.codemodel.impl.IdentifierNameImpl;
import org.hisrc.jscm.codemodel.lang.Validate;

public class ObjectLiteralImpl
extends PrimaryExpressionImpl
implements JSObjectLiteral {
    private final List<JSObjectLiteral.JSPropertyAssignment> propertyAssignments = new ArrayList<JSObjectLiteral.JSPropertyAssignment>();
    private final List<JSObjectLiteral.JSPropertyAssignment> unmodifiablePropertyAssignments = Collections.unmodifiableList(this.propertyAssignments);

    public ObjectLiteralImpl(JSCodeModel codeModel) {
        super(codeModel);
    }

    @Override
    public List<JSObjectLiteral.JSPropertyAssignment> getPropertyAssignments() {
        return this.unmodifiablePropertyAssignments;
    }

    @Override
    public JSObjectLiteral append(String name, JSAssignmentExpression expression) {
        return this.append(new IdentifierNameImpl(name), expression);
    }

    @Override
    public JSObjectLiteral append(JSPropertyName name, JSAssignmentExpression value) {
        this.propertyAssignments.add(new PropertyAssignmentImpl(name, value));
        return this;
    }

    @Override
    public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
        return visitor.visitObjectLiteral(this);
    }

    public static class PropertyAssignmentImpl
    implements JSObjectLiteral.JSPropertyAssignment {
        private final JSPropertyName name;
        private final JSAssignmentExpression value;

        public PropertyAssignmentImpl(JSPropertyName name, JSAssignmentExpression value) {
            Validate.notNull(name);
            Validate.notNull(value);
            this.name = name;
            this.value = value;
        }

        @Override
        public JSPropertyName getKey() {
            return this.name;
        }

        @Override
        public JSAssignmentExpression getValue() {
            return this.value;
        }
    }
}

