/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.expression.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.JSPropertyName;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSCallExpression;
import org.hisrc.jscm.codemodel.expression.JSExpression;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSMemberExpression;
import org.hisrc.jscm.codemodel.expression.impl.CallExpressionImpl;
import org.hisrc.jscm.codemodel.expression.impl.NewExpressionImpl;
import org.hisrc.jscm.codemodel.impl.IdentifierNameImpl;
import org.hisrc.jscm.codemodel.lang.Validate;

public abstract class MemberExpressionImpl
extends NewExpressionImpl
implements JSMemberExpression {
    public MemberExpressionImpl(JSCodeModel codeModel) {
        super(codeModel);
    }

    @Override
    public JSCallExpression.MemberCall i() {
        return this.invoke();
    }

    @Override
    public JSCallExpression.MemberCall invoke() {
        return new CallExpressionImpl.MemberCallImpl(this.getCodeModel(), this);
    }

    @Override
    public JSCallExpression.MemberCall invoke(String name) {
        Validate.notNull(name);
        return this.p(name).i();
    }

    @Override
    public JSCallExpression.MemberCall i(String name) {
        return this.invoke(name);
    }

    @Override
    public JSMemberExpression.MemberElement e(JSExpression index) {
        return this.element(index);
    }

    @Override
    public JSMemberExpression.MemberElement element(JSExpression index) {
        return new MemberElementImpl(this.getCodeModel(), this, index);
    }

    @Override
    public JSMemberExpression.MemberProperty p(JSPropertyName name) {
        return this.property(name);
    }

    @Override
    public JSMemberExpression.MemberProperty property(JSPropertyName name) {
        return new MemberPropertyImpl(this.getCodeModel(), this, name);
    }

    @Override
    public JSMemberExpression.MemberProperty p(String name) {
        return this.property(name);
    }

    @Override
    public JSMemberExpression.MemberProperty property(String name) {
        return new MemberPropertyImpl(this.getCodeModel(), this, new IdentifierNameImpl(name));
    }

    @Override
    public JSMemberExpression.MemberNew instantiate() {
        return new MemberNewImpl(this.getCodeModel(), this);
    }

    public static class MemberNewImpl
    extends MemberImpl
    implements JSMemberExpression.MemberNew {
        private final List<JSAssignmentExpression> args = new ArrayList<JSAssignmentExpression>();
        private final List<JSAssignmentExpression> unmodifiableArgs = Collections.unmodifiableList(this.args);

        public MemberNewImpl(JSCodeModel codeModel, JSMemberExpression base) {
            super(codeModel, base);
        }

        @Override
        public JSMemberExpression.MemberNew args(JSAssignmentExpression ... args) {
            Validate.noNullElements(args);
            this.args.addAll(Arrays.asList(args));
            return this;
        }

        @Override
        public List<JSAssignmentExpression> getArgs() {
            return this.unmodifiableArgs;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitMemberNew(this);
        }
    }

    public static class MemberPropertyImpl
    extends MemberImpl
    implements JSMemberExpression.MemberProperty {
        private final JSPropertyName name;

        public MemberPropertyImpl(JSCodeModel codeModel, JSMemberExpression base, JSPropertyName name) {
            super(codeModel, base);
            Validate.notNull(name);
            this.name = name;
        }

        @Override
        public JSPropertyName getName() {
            return this.name;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitMemberProperty(this);
        }
    }

    public static class MemberElementImpl
    extends MemberImpl
    implements JSMemberExpression.MemberElement {
        private final JSExpression index;

        public MemberElementImpl(JSCodeModel codeModel, JSMemberExpression base, JSExpression index) {
            super(codeModel, base);
            Validate.notNull(index);
            this.index = index;
        }

        @Override
        public JSExpression getIndex() {
            return this.index;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitMemberElement(this);
        }
    }

    public static abstract class MemberImpl
    extends MemberExpressionImpl
    implements JSMemberExpression.Member {
        private final JSMemberExpression base;

        public MemberImpl(JSCodeModel codeModel, JSMemberExpression base) {
            super(codeModel);
            Validate.notNull(base);
            this.base = base;
        }

        @Override
        public JSMemberExpression getBase() {
            return this.base;
        }
    }
}

