/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.path;

import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.validator.internal.engine.path.MaterializedPath;
import org.hibernate.validator.internal.engine.path.MutableNode;
import org.hibernate.validator.internal.metadata.aggregated.ExecutableMetaData;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.path.Path;

public final class MutablePath
implements Path,
Serializable {
    private static final long serialVersionUID = 2464836778339203598L;
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private static final String PROPERTY_PATH_SEPARATOR = ".";
    private static final String LEADING_PROPERTY_GROUP = "[^\\[\\.]++";
    private static final String OPTIONAL_INDEX_GROUP = "\\[(\\w*+)\\]";
    private static final String REMAINING_PROPERTY_STRING = "\\.(.++)";
    private static final Pattern PATH_PATTERN = Pattern.compile("([^\\[\\.]++)(\\[(\\w*+)\\])?(\\.(.++))*+");
    private static final int PROPERTY_NAME_GROUP = 1;
    private static final int INDEXED_GROUP = 2;
    private static final int INDEX_GROUP = 3;
    private static final int REMAINING_STRING_GROUP = 5;
    private MutableNode currentLeafNode;

    public static MutablePath createPathFromString(String propertyPath) {
        Contracts.assertNotNull(propertyPath, Messages.MESSAGES.propertyPathCannotBeNull());
        if (propertyPath.isEmpty()) {
            return MutablePath.createRootPath();
        }
        return MutablePath.parseProperty(propertyPath);
    }

    public static MutablePath createPathForExecutable(ExecutableMetaData executable) {
        Contracts.assertNotNull(executable, "A method is required to create a method return value path.");
        MutablePath path = MutablePath.createRootPath();
        if (executable.getKind() == ElementKind.CONSTRUCTOR) {
            path.addConstructorNode(executable.getName(), executable.getParameterTypes());
        } else {
            path.addMethodNode(executable.getName(), executable.getParameterTypes());
        }
        return path;
    }

    public static MutablePath createRootPath() {
        return new MutablePath(MutableNode.ROOT_NODE);
    }

    public static MutablePath createCopy(MutablePath path) {
        return new MutablePath(path);
    }

    public static MutablePath createCopyWithoutLeafNode(MutablePath path) {
        return new MutablePath(path.currentLeafNode.getParent());
    }

    public void addPropertyNode(String nodeName) {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createPropertyNode(nodeName, parent);
    }

    public void addContainerElementNode(String nodeName) {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createContainerElementNode(nodeName, parent);
    }

    public boolean needToAddContainerElementNode(String nodeName) {
        return nodeName != null || this.currentLeafNode.isIterable();
    }

    public void addParameterNode(String nodeName, int index) {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createParameterNode(nodeName, parent, index);
    }

    public void addCrossParameterNode() {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createCrossParameterNode(parent);
    }

    public void addBeanNode() {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createBeanNode(parent);
    }

    public void addReturnValueNode() {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createReturnValue(parent);
    }

    private void addConstructorNode(String name, Class<?>[] parameterTypes) {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createConstructorNode(name, parent, parameterTypes);
    }

    private void addMethodNode(String name, Class<?>[] parameterTypes) {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createMethodNode(name, parent, parameterTypes);
    }

    public void addEmptyNode() {
        MutableNode parent = this.currentLeafNode;
        this.currentLeafNode = MutableNode.createNode(parent);
    }

    public void makeLeafNodeIterable() {
        this.currentLeafNode.makeIterable();
    }

    public void makeLeafNodeIterableAndSetIndex(Integer index) {
        this.currentLeafNode.makeIterableAndSetIndex(index);
    }

    public void makeLeafNodeIterableAndSetMapKey(Object key) {
        this.currentLeafNode.makeIterableAndSetMapKey(key);
    }

    public void setLeafNodeValueIfRequired(Object value) {
        if (this.currentLeafNode.getKind() == ElementKind.PROPERTY || this.currentLeafNode.getKind() == ElementKind.CONTAINER_ELEMENT) {
            this.currentLeafNode.setPropertyValue(value);
        }
    }

    public void setLeafNodeTypeParameter(Class<?> containerClass, Integer typeArgumentIndex) {
        this.currentLeafNode.setTypeParameter(containerClass, typeArgumentIndex);
    }

    public void removeLeafNode() {
        if (this.currentLeafNode != null) {
            this.currentLeafNode = this.currentLeafNode.getParent();
        }
    }

    public MutableNode getLeafNode() {
        return this.currentLeafNode;
    }

    public Iterator<Path.Node> iterator() {
        if (this.currentLeafNode == null) {
            return Collections.emptyIterator();
        }
        return new MutableNode.NodeIterator(MutableNode.constructPath(this.currentLeafNode));
    }

    public Path materialize() {
        return new MaterializedPath(this);
    }

    public String asString() {
        return MutablePath.asString(this.currentLeafNode);
    }

    static String asString(MutableNode currentLeafNode) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        MutableNode current = currentLeafNode;
        while (!current.isRootPath()) {
            String name = current.asString();
            if (name.isEmpty()) {
                current = current.getParent();
                continue;
            }
            if (!first) {
                builder.insert(0, PROPERTY_PATH_SEPARATOR);
            }
            builder.insert(0, current.asString());
            first = false;
            current = current.getParent();
        }
        return builder.toString();
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("equals() should not be called. This mutable path is for internal use only and there should be a single instance of it per validation request, hence it should not be compared/put into a hash collection");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() should not be called. This mutable path is for internal use only and there should be a single instance of it per validation request, hence it should not be compared/put into a hash collection");
    }

    private MutablePath(MutablePath path) {
        this.currentLeafNode = path.currentLeafNode;
    }

    private MutablePath(MutableNode currentLeafNode) {
        this.currentLeafNode = currentLeafNode;
    }

    private static MutablePath parseProperty(String propertyName) {
        MutablePath path = MutablePath.createRootPath();
        String tmp = propertyName;
        do {
            Matcher matcher;
            if ((matcher = PATH_PATTERN.matcher(tmp)).matches()) {
                String indexOrKey;
                String value = matcher.group(1);
                if (!MutablePath.isValidJavaIdentifier(value)) {
                    throw LOG.getInvalidJavaIdentifierException(value);
                }
                path.addPropertyNode(value);
                if (matcher.group(2) != null) {
                    path.makeLeafNodeIterable();
                }
                if ((indexOrKey = matcher.group(3)) != null && !indexOrKey.isEmpty()) {
                    try {
                        Integer i = Integer.parseInt(indexOrKey);
                        path.makeLeafNodeIterableAndSetIndex(i);
                    }
                    catch (NumberFormatException e) {
                        path.makeLeafNodeIterableAndSetMapKey(indexOrKey);
                    }
                }
            } else {
                throw LOG.getUnableToParsePropertyPathException(propertyName);
            }
            tmp = matcher.group(5);
        } while (tmp != null);
        if (path.getLeafNode().isIterable()) {
            path.addBeanNode();
        }
        return path;
    }

    private static boolean isValidJavaIdentifier(String identifier) {
        Contracts.assertNotNull(identifier, "identifier param cannot be null");
        if (identifier.isEmpty() || !Character.isJavaIdentifierStart((int)identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (Character.isJavaIdentifierPart((int)identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated(forRemoval=true, since="9.1")
    public boolean isSubPathOf(MutablePath other) {
        if (this.currentLeafNode == null) {
            return other.currentLeafNode == null;
        }
        return this.currentLeafNode.isSubPathOf(other.currentLeafNode);
    }

    @Deprecated(forRemoval=true, since="9.1")
    public boolean isSubPathOrContains(MutablePath other) {
        if (this.currentLeafNode == null) {
            return other.currentLeafNode == null;
        }
        return this.currentLeafNode.isSubPathOrContains(other.currentLeafNode);
    }
}

