/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.scope.impl;

import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.scope.spi.V5MigrationSearchScope;

public class V5MigrationOrmSearchScopeAdapter
implements V5MigrationSearchScope {
    private final SearchScope<?> delegate;

    public V5MigrationOrmSearchScopeAdapter(SearchScope<?> delegate) {
        this.delegate = delegate;
    }

    public Set<Class<?>> targetTypes() {
        return this.delegate.includedTypes().stream().map(SearchIndexedEntity::javaClass).collect(Collectors.toSet());
    }

    public Set<IndexManager> indexManagers() {
        return this.delegate.includedTypes().stream().map(SearchIndexedEntity::indexManager).collect(Collectors.toSet());
    }

    public SearchPredicateFactory predicate() {
        return this.delegate.predicate();
    }

    public SearchSortFactory sort() {
        return this.delegate.sort();
    }

    public SearchProjectionFactory<?, ?> projection() {
        return this.delegate.projection();
    }

    public SearchProjection<Object> idProjection() {
        SearchProjectionFactory factory = this.delegate.projection();
        return factory.composite(EntityReference::id, (ProjectionFinalStep)factory.entityReference()).toProjection();
    }

    public SearchProjection<? extends Class<?>> objectClassProjection() {
        SearchProjectionFactory factory = this.delegate.projection();
        return factory.composite(EntityReference::type, (ProjectionFinalStep)factory.entityReference()).toProjection();
    }

    public SearchAggregationFactory aggregation() {
        return this.delegate.aggregation();
    }

    public SearchScope<?> toSearchScope() {
        return this.delegate;
    }
}

