/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.schema.management.impl;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.mapper.pojo.schema.management.SearchSchemaCollector;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.standalone.reporting.impl.StandalonePojoEventContextMessages;
import org.hibernate.search.mapper.pojo.standalone.schema.management.SearchSchemaManager;
import org.hibernate.search.util.common.function.TriFunction;
import org.hibernate.search.util.common.impl.Futures;

public class SearchSchemaManagerImpl
implements SearchSchemaManager {
    private final PojoScopeSchemaManager delegate;

    public SearchSchemaManagerImpl(PojoScopeSchemaManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void validate() {
        this.doOperation(PojoScopeSchemaManager::validate);
    }

    @Override
    public void createIfMissing() {
        this.doOperation(PojoScopeSchemaManager::createIfMissing);
    }

    @Override
    public void createOrValidate() {
        this.doOperation(PojoScopeSchemaManager::createOrValidate);
    }

    @Override
    public void createOrUpdate() {
        this.doOperation(PojoScopeSchemaManager::createOrUpdate);
    }

    @Override
    public void dropIfExisting() {
        this.doOperation(PojoScopeSchemaManager::dropIfExisting);
    }

    @Override
    public void dropAndCreate() {
        this.doOperation(PojoScopeSchemaManager::dropAndCreate);
    }

    @Override
    public void exportExpectedSchema(SearchSchemaCollector collector) {
        this.delegate.exportExpectedSchema(collector);
    }

    @Override
    public void exportExpectedSchema(Path targetDirectory) {
        this.delegate.exportExpectedSchema(targetDirectory);
    }

    private void doOperation(TriFunction<PojoScopeSchemaManager, FailureCollector, OperationSubmitter, CompletableFuture<?>> operation) {
        RootFailureCollector failureCollector = new RootFailureCollector(StandalonePojoEventContextMessages.INSTANCE.schemaManagement());
        try {
            Futures.unwrappedExceptionJoin((CompletableFuture)((CompletableFuture)operation.apply((Object)this.delegate, (Object)failureCollector, (Object)OperationSubmitter.blocking())));
        }
        catch (RuntimeException e) {
            failureCollector.withContext(EventContexts.defaultContext()).add((Throwable)e);
        }
        failureCollector.checkNoFailure();
    }
}

