/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.bootstrap.impl;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.spi.SearchIntegrationFinalizer;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoMapping;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoMappingKey;
import org.hibernate.search.util.common.AssertionFailure;

final class StandalonePojoIntegrationPartialBuildState {
    private static final OptionalConfigurationProperty<StandalonePojoIntegrationPartialBuildState> INTEGRATION_PARTIAL_BUILD_STATE = ConfigurationProperty.forKey((String)"hibernate.search.integration_partial_build_state").as(StandalonePojoIntegrationPartialBuildState.class, StandalonePojoIntegrationPartialBuildState::parse).build();
    private final SearchIntegrationPartialBuildState integrationBuildState;
    private final StandalonePojoMappingKey mappingKey;

    public static Optional<StandalonePojoIntegrationPartialBuildState> get(ConfigurationPropertySource propertySource) {
        return (Optional)INTEGRATION_PARTIAL_BUILD_STATE.get(propertySource);
    }

    private static StandalonePojoIntegrationPartialBuildState parse(String stringToParse) {
        throw new AssertionFailure("The partial build state cannot be parsed from a String; it must be null or an instance of " + StandalonePojoIntegrationPartialBuildState.class);
    }

    StandalonePojoIntegrationPartialBuildState(SearchIntegrationPartialBuildState integrationBuildState, StandalonePojoMappingKey mappingKey) {
        this.integrationBuildState = integrationBuildState;
        this.mappingKey = mappingKey;
    }

    public void closeOnFailure() {
        this.integrationBuildState.closeOnFailure();
    }

    void set(BiConsumer<String, Object> propertyCollector) {
        propertyCollector.accept("hibernate.search.integration_partial_build_state", this);
    }

    BeanResolver beanResolver() {
        return this.integrationBuildState.beanResolver();
    }

    StandalonePojoMapping doBootSecondPhase(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker propertyChecker) {
        SearchIntegrationFinalizer finalizer = this.integrationBuildState.finalizer(propertySource, propertyChecker);
        StandalonePojoMapping mapping = (StandalonePojoMapping)finalizer.finalizeMapping((MappingKey)this.mappingKey, (context, partialMapping) -> partialMapping.finalizeMapping(context));
        finalizer.finalizeIntegration();
        return mapping;
    }
}

