package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.search.mapper.pojo.common.annotation.impl.SearchProcessingWithContextException;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.engine.common.EntityReference;
import java.lang.Throwable;
import java.util.List;
import java.lang.Class;
import java.util.Arrays;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

/**
 * Warning this class consists of generated code.
 */
public class IndexingLog_$logger implements IndexingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = IndexingLog_$logger.class.getName();
    public IndexingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String searchProcessingFailure$str() {
        return "%1$s";
    }
    @Override
    public final SearchProcessingWithContextException searchProcessingFailure(final Throwable cause, final String causeMessage, final EventContext context) {
        final SearchProcessingWithContextException result = new SearchProcessingWithContextException(String.format(getLoggingLocale(), searchProcessingFailure$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String nullProvidedIdentifier$str() {
        return "HSEARCH700038: The entity identifier must not be null.";
    }
    @Override
    public final SearchException nullProvidedIdentifier() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullProvidedIdentifier$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String recursiveIndexingPlanProcess$str() {
        return "HSEARCH700060: Unable to trigger entity processing while already processing entities. Make sure you do not change entities within an entity getter or a custom bridge used for indexing, and avoid any event that could trigger entity processing. Hibernate ORM flushes, in particular, must be avoided in entity getters and bridges.";
    }
    @Override
    public final SearchException recursiveIndexingPlanProcess() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), recursiveIndexingPlanProcess$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorBuildingDocument$str() {
        return "HSEARCH700083: Exception while building document for entity '%1$s': %2$s";
    }
    @Override
    public final SearchException errorBuildingDocument(final EntityReference entityReference, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorBuildingDocument$str(), entityReference, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorResolvingEntitiesToReindex$str() {
        return "HSEARCH700084: Exception while resolving other entities to reindex as a result of changes on entity '%1$s': %2$s";
    }
    @Override
    public final SearchException errorResolvingEntitiesToReindex(final EntityReference entityReference, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorResolvingEntitiesToReindex$str(), entityReference, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullProvidedIdentifierAndEntity$str() {
        return "HSEARCH700087: Invalid indexing request: if the entity is null, the identifier must be provided explicitly.";
    }
    @Override
    public final SearchException nullProvidedIdentifierAndEntity() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullProvidedIdentifierAndEntity$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullEntityForIndexerAddOrUpdate$str() {
        return "HSEARCH700088: Invalid indexing request: the add and update operations require a non-null entity.";
    }
    @Override
    public final SearchException nullEntityForIndexerAddOrUpdate() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullEntityForIndexerAddOrUpdate$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexingFailure$str() {
        return "HSEARCH700124: Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.";
    }
    @Override
    public final SearchException indexingFailure(final String causeMessage, final List<?> failingEntities, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexingFailure$str(), causeMessage, failingEntities), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String attemptToCreateIndexingPlanForExcludedType$str() {
        return "HSEARCH700128: Indexing plan for '%1$s' cannot be created as this type is excluded by the indexing plan filter.";
    }
    @Override
    public final SearchException attemptToCreateIndexingPlanForExcludedType(final PojoRawTypeIdentifier<?> typeIdentifier) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), attemptToCreateIndexingPlanForExcludedType$str(), typeIdentifier));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexingPlanFilterCannotIncludeExcludeSameType$str() {
        return "HSEARCH700129: '%1$s' cannot be included and excluded at the same time within one filter. Already included types: '%2$s'. Already excluded types: '%3$s'.";
    }
    @Override
    public final SearchException indexingPlanFilterCannotIncludeExcludeSameType(final PojoRawTypeIdentifier<?> typeIdentifier, final Set<PojoRawTypeIdentifier<?>> includes, final Set<PojoRawTypeIdentifier<?>> excludes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexingPlanFilterCannotIncludeExcludeSameType$str(), typeIdentifier, includes, excludes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSelectionLoadingStrategy$str() {
        return "HSEARCH700155: Cannot load entities of type '%s': no selection loading strategy registered for this type.";
    }
    @Override
    public final SearchException noSelectionLoadingStrategy(final String entityName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noSelectionLoadingStrategy$str(), entityName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noMassLoadingStrategy$str() {
        return "HSEARCH700156: Cannot load entities of type '%s': no mass loading strategy registered for this type.";
    }
    @Override
    public final SearchException noMassLoadingStrategy(final String entityName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noMassLoadingStrategy$str(), entityName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String loadingConfigurationTypeMismatch$str() {
        return "HSEARCH700157: Type mismatch when applying loading binder to type '%1$s': the binder expects the entity type to extend '%2$s', but entity type '%1$s' does not.";
    }
    @Override
    public final SearchException loadingConfigurationTypeMismatch(final PojoRawTypeModel<?> entityType, final Class<?> expectedSuperType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), loadingConfigurationTypeMismatch$str(), new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(entityType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedSuperType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
