/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.common.tree.spi.TreeFilterPathTracker;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingMapperContext;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.engine.mapper.model.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexModelBinder;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;

public class PojoMappingHelper
implements IndexedEntityBindingMapperContext {
    private final BeanResolver beanResolver;
    private final ContextualFailureCollector failureCollector;
    private final TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider;
    private final PojoBootstrapIntrospector introspector;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final PojoIndexModelBinder indexModelBinder;
    private final Map<MappingElement, TreeFilterPathTracker> pathTrackers = new LinkedHashMap<MappingElement, TreeFilterPathTracker>();

    PojoMappingHelper(BeanResolver beanResolver, ContextualFailureCollector failureCollector, TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider, PojoBootstrapIntrospector introspector, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider, PojoIndexModelBinder indexModelBinder) {
        this.beanResolver = beanResolver;
        this.failureCollector = failureCollector;
        this.contributorProvider = contributorProvider;
        this.introspector = introspector;
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
        this.indexModelBinder = indexModelBinder;
    }

    public BeanResolver beanResolver() {
        return this.beanResolver;
    }

    public FailureCollector failureCollector() {
        return this.failureCollector;
    }

    public TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider() {
        return this.contributorProvider;
    }

    public PojoBootstrapIntrospector introspector() {
        return this.introspector;
    }

    public PojoIndexModelBinder indexModelBinder() {
        return this.indexModelBinder;
    }

    public PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider() {
        return this.typeAdditionalMetadataProvider;
    }

    public TreeFilterPathTracker getOrCreatePathTracker(MappingElement mappingElement, TreeFilterDefinition filterDefinition) {
        TreeFilterPathTracker result = this.pathTrackers.get(mappingElement);
        if (result != null) {
            return result;
        }
        result = new TreeFilterPathTracker(filterDefinition);
        this.pathTrackers.put(mappingElement, result);
        return result;
    }

    void checkPathTrackers() {
        for (Map.Entry<MappingElement, TreeFilterPathTracker> entry : this.pathTrackers.entrySet()) {
            Set uselessExcludePaths;
            TreeFilterPathTracker pathTracker = entry.getValue();
            Set uselessIncludePaths = pathTracker.uselessIncludePaths();
            if (!uselessIncludePaths.isEmpty()) {
                Set encounteredFieldPaths = pathTracker.encounteredFieldPaths();
                this.failureCollector.add((Throwable)MappingLog.INSTANCE.uselessIncludePathFilters(entry.getKey(), uselessIncludePaths, encounteredFieldPaths, entry.getKey().eventContext()));
            }
            if ((uselessExcludePaths = pathTracker.uselessExcludePaths()).isEmpty()) continue;
            Set encounteredFieldPaths = pathTracker.encounteredFieldPaths();
            this.failureCollector.add((Throwable)MappingLog.INSTANCE.uselessExcludePathFilters(entry.getKey(), uselessExcludePaths, encounteredFieldPaths, entry.getKey().eventContext()));
        }
    }
}

