package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoConstructorProjectionDefinition;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.hibernate.search.mapper.pojo.search.definition.impl.ConstructorProjectionApplicationException;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.mapper.pojo.model.path.spi.ProjectionConstructorPath;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class ProjectionLog_$logger implements ProjectionLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProjectionLog_$logger.class.getName();
    public ProjectionLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidObjectClassForProjection$str() {
        return "HSEARCH700112: Invalid object class for projection: %1$s. Make sure that this class is mapped correctly, either through annotations (@ProjectionConstructor) or programmatic mapping. If it is, make sure the class is included in a Jandex index made available to Hibernate Search.";
    }
    @Override
    public final SearchException invalidObjectClassForProjection(final Class<?> objectClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidObjectClassForProjection$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(objectClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidAbstractTypeForProjectionConstructor$str() {
        return "HSEARCH700113: Invalid declaring type for projection constructor: type '%1$s' is abstract. Projection constructors can only be declared on concrete types.";
    }
    @Override
    public final SearchException invalidAbstractTypeForProjectionConstructor(final PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAbstractTypeForProjectionConstructor$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingParameterNameForInferredProjection$str() {
        return "HSEARCH700114: Missing parameter names in Java metadata for projection constructor. When inferring inner projections from constructor parameters, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@FieldProjection(path = ...)' or '@ObjectProjection(path = ...)'.";
    }
    @Override
    public final SearchException missingParameterNameForInferredProjection() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingParameterNameForInferredProjection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMultiValuedParameterTypeForProjectionConstructor$str() {
        return "HSEARCH700115: Invalid parameter type for projection constructor: %1$s. When inferring the cardinality of inner projections from constructor parameters, multi-valued constructor parameters must be lists/sets (java.util.List<...>/java.util.Set<...>/java.util.SortedSet<...>), their supertypes (java.lang.Iterable<...>, java.util.Collection<...>) or arrays";
    }
    @Override
    public final SearchException invalidMultiValuedParameterTypeForProjectionConstructor(final PojoTypeModel<?> parentTypeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiValuedParameterTypeForProjectionConstructor$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleProjectionConstructorsForType$str() {
        return "HSEARCH700116: Multiple projection constructor are mapped for type '%1$s'. At most one projection constructor is allowed for each type.";
    }
    @Override
    public final SearchException multipleProjectionConstructorsForType(final Class<?> instantiatedJavaClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleProjectionConstructorsForType$str(), instantiatedJavaClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void constructorProjection(final PojoRawTypeModel<?> typeModel, final PojoConstructorProjectionDefinition<?> projectionDefinition) {
        log.logf(FQCN, DEBUG, null, constructorProjection$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter(projectionDefinition));
    }
    protected String constructorProjection$str() {
        return "HSEARCH700117: Constructor projection for type '%1$s': %2$s";
    }
    protected String objectProjectionCyclicRecursion$str() {
        return "HSEARCH700118: Cyclic recursion starting from '%1$s' on %2$s. Index field path starting from that location and ending with a cycle: '%3$s'. A projection constructor cannot declare an unrestricted @ObjectProjection to itself, even indirectly. To break the cycle, you should consider adding filters to your @ObjectProjection: includePaths, includeDepth, excludePaths, ...";
    }
    @Override
    public final SearchException objectProjectionCyclicRecursion(final MappingElement objectProjection, final EventContext objectProjectionLocation, final String cyclicRecursionIndexFieldPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), objectProjectionCyclicRecursion$str(), objectProjection, new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(objectProjectionLocation), cyclicRecursionIndexFieldPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorApplyingProjectionConstructor$str() {
        return "HSEARCH700123: Could not apply projection constructor: %1$s";
    }
    @Override
    public final ConstructorProjectionApplicationException errorApplyingProjectionConstructor(final String causeMessage, final Exception cause, final ProjectionConstructorPath path) {
        final ConstructorProjectionApplicationException result = new ConstructorProjectionApplicationException(String.format(getLoggingLocale(), errorApplyingProjectionConstructor$str(), causeMessage), cause, path);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleProjectionMappingsForParameter$str() {
        return "HSEARCH700134: Multiple projections are mapped for this parameter. At most one projection is allowed for each parameter.";
    }
    @Override
    public final SearchException multipleProjectionMappingsForParameter() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleProjectionMappingsForParameter$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingProjectionDefinitionForBinder$str() {
        return "HSEARCH700135: Incorrect binder implementation: binder '%1$s' did not call context.definition(...).";
    }
    @Override
    public final SearchException missingProjectionDefinitionForBinder(final Object binder) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingProjectionDefinitionForBinder$str(), binder));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidOutputTypeForProjectionDefinition$str() {
        return "HSEARCH700136: Invalid projection definition for constructor parameter type '%2$s': '%1$s'. This projection results in values of type '%3$s'.";
    }
    @Override
    public final SearchException invalidOutputTypeForProjectionDefinition(final Object definition, final PojoTypeModel<?> typeModel, final PojoTypeModel<?> expectedValueModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidOutputTypeForProjectionDefinition$str(), definition, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(expectedValueModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidOutputTypeForMultiValuedProjectionDefinition$str() {
        return "HSEARCH700137: Invalid multi-valued projection definition for constructor parameter type '%2$s': '%1$s'. This projection results in values of type '%3$s'.";
    }
    @Override
    public final SearchException invalidOutputTypeForMultiValuedProjectionDefinition(final Object definition, final PojoTypeModel<?> typeModel, final PojoTypeModel<?> expectedValueModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidOutputTypeForMultiValuedProjectionDefinition$str(), definition, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(expectedValueModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingParameterNameForFieldProjectionInProjectionConstructor$str() {
        return "HSEARCH700138: Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to a field projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@FieldProjection(path = ...)'.";
    }
    @Override
    public final SearchException missingParameterNameForFieldProjectionInProjectionConstructor() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingParameterNameForFieldProjectionInProjectionConstructor$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingParameterNameForObjectProjectionInProjectionConstructor$str() {
        return "HSEARCH700139: Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to an object projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@ObjectProjection(path = ...)'.";
    }
    @Override
    public final SearchException missingParameterNameForObjectProjectionInProjectionConstructor() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingParameterNameForObjectProjectionInProjectionConstructor$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingParameterNameForHighlightProjectionInProjectionConstructor$str() {
        return "HSEARCH700140: Missing parameter names in Java metadata for projection constructor. When mapping a projection constructor parameter to a highlight projection without providing a field path, constructor parameter names must be known. Either make sure this class was compiled with the '-parameters' compiler flag, or set the path explicitly with '@HighlightProjection(path = ...)'.";
    }
    @Override
    public final SearchException missingParameterNameForHighlightProjectionInProjectionConstructor() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingParameterNameForHighlightProjectionInProjectionConstructor$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameterTypeForHighlightProjectionInProjectionConstructor$str() {
        return "HSEARCH700141: Invalid constructor parameter type: '%1$s'. The highlight projection results in values of type '%2$s'.";
    }
    @Override
    public final SearchException invalidParameterTypeForHighlightProjectionInProjectionConstructor(final Class<?> rawClass, final String expectedClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidParameterTypeForHighlightProjectionInProjectionConstructor$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(rawClass), expectedClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameterTypeForDistanceProjectionInProjectionConstructor$str() {
        return "HSEARCH700159: Invalid constructor parameter type: '%1$s'. The distance projection results in values of type '%2$s'.";
    }
    @Override
    public final SearchException invalidParameterTypeForDistanceProjectionInProjectionConstructor(final Class<?> rawClass, final String expectedClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidParameterTypeForDistanceProjectionInProjectionConstructor$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(rawClass), expectedClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotBindSortedSetWithNonComparableElements$str() {
        return "HSEARCH700171: Implicit binding of a java.util.SortedSet<%1$s> constructor parameter is not possible since %1$s is not implementing java.lang.Comparable. Either make %1$s implement java.lang.Comparable or create a custom @ProjectionBinding and use the ProjectionCollector.sortedSet(comparator) collector provider in it.";
    }
    @Override
    public final SearchException cannotBindSortedSetWithNonComparableElements(final Class<?> elementType, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotBindSortedSetWithNonComparableElements$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(elementType)), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
