package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import java.lang.Class;
import java.lang.Object;
import java.lang.String;
import java.net.URISyntaxException;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
public class FormattingLog_$logger implements FormattingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = FormattingLog_$logger.class.getName();
    public FormattingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String parseException$str() {
        return "HSEARCH000295: Invalid value for type '$2%s': '$1%s'. %3$s";
    }
    @Override
    public final SearchException parseException(final String text, final Class<?> readerClass, final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), parseException$str(), text, new org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter(readerClass), causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String valueTooLargeForConversionException$str() {
        return "HSEARCH000297: Unable to convert '%2$s' into type '%1$s': value is too large.";
    }
    @Override
    public final SearchException valueTooLargeForConversionException(final Class<?> type, final Object duration, final Exception ae) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), valueTooLargeForConversionException$str(), new org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter(type), duration), ae);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String malformedURL$str() {
        return "HSEARCH700043: Exception creating URL from String '%1$s'.";
    }
    @Override
    public final SearchException malformedURL(final String value, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), malformedURL$str(), value), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String badURISyntax$str() {
        return "HSEARCH700044: Exception creating URI from String '%1$s'.";
    }
    @Override
    public final SearchException badURISyntax(final String value, final URISyntaxException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), badURISyntax$str(), value), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonStringTenantId$str() {
        return "HSEARCH700158: A non-string tenant ID '%1$s' cannot be used with a default TenantIdentifierConverter. Provide your custom implementation of TenantIdentifierConverter to use non-string tenant identifiers.";
    }
    @Override
    public final SearchException nonStringTenantId(final Object tenantId) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonStringTenantId$str(), tenantId));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
