/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.impl.MassIndexingOperationHandledFailureException;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexerAgentCreateContextImpl;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexerAgentStartContextImpl;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingBatchIndexingWorkspace;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailureHandledRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgent;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingMappingContext;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContextMessages;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;

public class PojoMassIndexingBatchCoordinator
extends PojoMassIndexingFailureHandledRunnable {
    private final PojoMassIndexingMappingContext mappingContext;
    private final PojoMassIndexerAgentStartContextImpl agentStartContext;
    private final List<PojoMassIndexingIndexedTypeGroup<?>> typeGroupsToIndex;
    private final PojoScopeSchemaManager scopeSchemaManager;
    private final Set<String> tenantIds;
    private final PojoScopeDelegate<?, ?, ?> pojoScopeDelegate;
    private final int typesToIndexInParallel;
    private final int documentBuilderThreads;
    private final boolean mergeSegmentsOnFinish;
    private final boolean dropAndCreateSchemaOnStart;
    private final boolean purgeAtStart;
    private final boolean mergeSegmentsAfterPurge;
    private final List<CompletableFuture<?>> indexingFutures = new ArrayList();
    private final Collection<SessionContext> sessionContexts = new ArrayList<SessionContext>();
    private PojoScopeWorkspace allTenantsWorkspace;

    public PojoMassIndexingBatchCoordinator(PojoMassIndexingMappingContext mappingContext, PojoMassIndexingNotifier notifier, List<PojoMassIndexingIndexedTypeGroup<?>> typeGroupsToIndex, PojoScopeSchemaManager scopeSchemaManager, Set<String> tenantIds, PojoScopeDelegate<?, ?, ?> pojoScopeDelegate, MassIndexingEnvironment environment, int typesToIndexInParallel, int documentBuilderThreads, boolean mergeSegmentsOnFinish, boolean dropAndCreateSchemaOnStart, boolean purgeAtStart, boolean mergeSegmentsAfterPurge) {
        super(notifier, environment);
        this.mappingContext = mappingContext;
        this.typeGroupsToIndex = typeGroupsToIndex;
        this.scopeSchemaManager = scopeSchemaManager;
        this.tenantIds = tenantIds;
        this.pojoScopeDelegate = pojoScopeDelegate;
        this.typesToIndexInParallel = typesToIndexInParallel;
        this.documentBuilderThreads = documentBuilderThreads;
        this.mergeSegmentsOnFinish = mergeSegmentsOnFinish;
        this.dropAndCreateSchemaOnStart = dropAndCreateSchemaOnStart;
        this.purgeAtStart = purgeAtStart;
        this.mergeSegmentsAfterPurge = mergeSegmentsAfterPurge;
        this.agentStartContext = new PojoMassIndexerAgentStartContextImpl(mappingContext.threadPoolProvider(), mappingContext.failureHandler());
    }

    @Override
    public void runWithFailureHandler() throws InterruptedException {
        if (!this.indexingFutures.isEmpty()) {
            throw new AssertionFailure("BatchCoordinator instance not expected to be reused");
        }
        this.beforeBatch();
        try {
            this.doBatchWork();
            this.afterBatch();
        }
        catch (MassIndexingOperationHandledFailureException e) {
            this.cleanUpOnFailure();
        }
    }

    private void beforeBatch() throws InterruptedException {
        this.allTenantsWorkspace = this.pojoScopeDelegate.workspace(this.tenantIds);
        for (String tenantId : this.tenantIds) {
            this.sessionContexts.add(this.createSessionContext(tenantId));
        }
        if (this.sessionContexts.isEmpty()) {
            this.sessionContexts.add(this.createSessionContext(null));
        }
        this.applyToAllContexts(c -> c.agent().start(this.agentStartContext));
        if (this.dropAndCreateSchemaOnStart) {
            RootFailureCollector failureCollector = new RootFailureCollector(PojoEventContextMessages.INSTANCE.schemaManagement());
            Futures.unwrappedExceptionGet(this.scopeSchemaManager.dropAndCreate((FailureCollector)failureCollector, OperationSubmitter.blocking()));
            failureCollector.checkNoFailure();
        }
        if (this.purgeAtStart) {
            Futures.unwrappedExceptionGet(this.allTenantsWorkspace.purge(Collections.emptySet(), OperationSubmitter.blocking()));
            if (this.mergeSegmentsAfterPurge) {
                Futures.unwrappedExceptionGet(this.allTenantsWorkspace.mergeSegments(OperationSubmitter.blocking()));
            }
        }
    }

    private SessionContext createSessionContext(String tenantId) {
        return new SessionContext(this.mappingContext.createMassIndexerAgent(new PojoMassIndexerAgentCreateContextImpl(this.mappingContext, tenantId)), this.pojoScopeDelegate.workspace(tenantId), tenantId);
    }

    private void doBatchWork() throws InterruptedException {
        ThreadPoolExecutor executor = this.mappingContext.threadPoolProvider().newFixedThreadPool(this.typesToIndexInParallel, "Mass indexing - Workspace");
        for (PojoMassIndexingIndexedTypeGroup<?> typeGroup : this.typeGroupsToIndex) {
            for (SessionContext context : this.sessionContexts) {
                this.indexingFutures.add(Futures.runAsync(this.createBatchIndexingWorkspace(typeGroup, context), (ExecutorService)executor));
            }
        }
        executor.shutdown();
        Futures.unwrappedExceptionGet(CompletableFuture.allOf(this.indexingFutures.toArray(new CompletableFuture[0])));
    }

    private <E> PojoMassIndexingBatchIndexingWorkspace<E, ?> createBatchIndexingWorkspace(PojoMassIndexingIndexedTypeGroup<E> typeGroup, SessionContext context) {
        return new PojoMassIndexingBatchIndexingWorkspace(this.mappingContext, this.getNotifier(), this.getMassIndexingEnvironment(), typeGroup, typeGroup.loadingStrategy(), this.documentBuilderThreads, context.tenantIdentifier());
    }

    private void afterBatch() throws InterruptedException {
        if (this.mergeSegmentsOnFinish) {
            Futures.unwrappedExceptionGet(this.allTenantsWorkspace.mergeSegments(OperationSubmitter.blocking()));
        }
        this.flushAndRefresh();
        this.applyToAllContexts(context -> context.agent().preStop());
        for (SessionContext context2 : this.sessionContexts) {
            context2.agent().stop();
        }
        this.sessionContexts.clear();
        this.agentStartContext.clear();
    }

    private void flushAndRefresh() throws InterruptedException {
        Futures.unwrappedExceptionGet(this.allTenantsWorkspace.flush(OperationSubmitter.blocking()));
        Futures.unwrappedExceptionGet(this.allTenantsWorkspace.refresh(OperationSubmitter.blocking()));
    }

    @Override
    protected void cleanUpOnInterruption() throws InterruptedException {
        try (Closer closer = new Closer();){
            closer.pushAll(this::cancelPendingTask, this.indexingFutures);
            closer.push(PojoMassIndexingBatchCoordinator::flushAndRefresh, (Object)this);
            closer.pushAll(PojoMassIndexerAgent::stop, this.sessionContexts, SessionContext::agent);
            closer.push(PojoMassIndexerAgentStartContextImpl::clear, (Object)this.agentStartContext);
            this.sessionContexts.clear();
        }
    }

    @Override
    protected void cleanUpOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(this::cancelPendingTask, this.indexingFutures);
            closer.pushAll(PojoMassIndexerAgent::stop, this.sessionContexts, SessionContext::agent);
            closer.push(PojoMassIndexerAgentStartContextImpl::clear, (Object)this.agentStartContext);
            this.sessionContexts.clear();
        }
    }

    private void cancelPendingTask(Future<?> task) {
        if (!task.isDone()) {
            task.cancel(true);
        }
    }

    @Override
    protected void notifySuccess() {
        this.getNotifier().reportIndexingCompleted();
    }

    @Override
    protected void notifyInterrupted(InterruptedException exception) {
        this.getNotifier().reportInterrupted(exception);
        this.getNotifier().reportIndexingCompleted();
    }

    @Override
    protected void notifyFailure(RuntimeException exception) {
        super.notifyFailure(exception);
        this.getNotifier().reportIndexingCompleted();
    }

    private void applyToAllContexts(Function<SessionContext, CompletableFuture<?>> operation) throws InterruptedException {
        Futures.unwrappedExceptionGet(CompletableFuture.allOf((CompletableFuture[])this.sessionContexts.stream().map(operation::apply).toArray(CompletableFuture[]::new)));
    }

    public static class SessionContext {
        private final PojoMassIndexerAgent agent;
        private final PojoScopeWorkspace scopeWorkspace;
        private final String tenantIdentifier;

        public SessionContext(PojoMassIndexerAgent agent, PojoScopeWorkspace scopeWorkspace, String tenantIdentifier) {
            this.agent = agent;
            this.scopeWorkspace = scopeWorkspace;
            this.tenantIdentifier = tenantIdentifier;
        }

        public PojoMassIndexerAgent agent() {
            return this.agent;
        }

        public PojoScopeWorkspace scopeWorkspace() {
            return this.scopeWorkspace;
        }

        public String tenantIdentifier() {
            return this.tenantIdentifier;
        }
    }
}

