/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.JavaClassPojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractPojoRawTypeModel<T, I extends PojoBootstrapIntrospector>
implements PojoRawTypeModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final I introspector;
    protected final PojoRawTypeIdentifier<T> typeIdentifier;
    private final PojoCaster<T> caster;
    private final Map<String, PojoPropertyModel<?>> propertyModelCache = new HashMap();
    private List<PojoPropertyModel<?>> declaredProperties;
    private List<PojoConstructorModel<T>> declaredConstructors;

    public AbstractPojoRawTypeModel(I introspector, PojoRawTypeIdentifier<T> typeIdentifier) {
        this.introspector = introspector;
        this.typeIdentifier = typeIdentifier;
        this.caster = new JavaClassPojoCaster<T>(typeIdentifier.javaClass());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPojoRawTypeModel that = (AbstractPojoRawTypeModel)o;
        return Objects.equals(this.introspector, that.introspector) && Objects.equals(this.typeIdentifier, that.typeIdentifier);
    }

    public final int hashCode() {
        return Objects.hash(this.introspector, this.typeIdentifier);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.typeIdentifier + "]";
    }

    @Override
    public final PojoRawTypeIdentifier<T> typeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public final String name() {
        return this.typeIdentifier.toString();
    }

    @Override
    public final PojoConstructorModel<T> mainConstructor() {
        Collection<PojoConstructorModel<T>> theDeclaredConstructors = this.declaredConstructors();
        if (theDeclaredConstructors.size() != 1) {
            throw log.cannotFindMainConstructorNotExactlyOneConstructor(this);
        }
        return theDeclaredConstructors.iterator().next();
    }

    @Override
    public final PojoConstructorModel<T> constructor(Class<?> ... parameterTypes) {
        for (PojoConstructorModel<T> constructor : this.declaredConstructors()) {
            if (!Arrays.equals(parameterTypes, constructor.parametersJavaTypes())) continue;
            return constructor;
        }
        throw log.cannotFindConstructorWithParameterTypes(this, parameterTypes, this.declaredConstructors());
    }

    @Override
    public Collection<PojoConstructorModel<T>> declaredConstructors() {
        if (this.declaredConstructors == null) {
            this.declaredConstructors = this.createDeclaredConstructors();
        }
        return this.declaredConstructors;
    }

    protected abstract List<PojoConstructorModel<T>> createDeclaredConstructors();

    @Override
    public final PojoPropertyModel<?> property(String propertyName) {
        PojoPropertyModel<?> propertyModel = this.propertyOrNull(propertyName);
        if (propertyModel == null) {
            throw log.cannotFindReadableProperty(this, propertyName);
        }
        return propertyModel;
    }

    @Override
    public final Collection<PojoPropertyModel<?>> declaredProperties() {
        if (this.declaredProperties == null) {
            this.declaredProperties = Collections.unmodifiableList(this.declaredPropertyNames().map(this::propertyOrNull).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return this.declaredProperties;
    }

    @Override
    public final PojoCaster<T> caster() {
        return this.caster;
    }

    @Override
    public <U> Optional<PojoTypeModel<? extends U>> castTo(Class<U> target) {
        return Optional.empty();
    }

    protected abstract Stream<String> declaredPropertyNames();

    protected abstract PojoPropertyModel<?> createPropertyModel(String var1);

    private PojoPropertyModel<?> propertyOrNull(String propertyName) {
        return this.propertyModelCache.computeIfAbsent(propertyName, this::createPropertyModel);
    }
}

