/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.hcann.spi;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnRawTypeModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoHCAnnMethodParameterModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueCreateHandle;

public class PojoHCAnnConstructorModel<T>
implements PojoConstructorModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractPojoHCAnnBootstrapIntrospector introspector;
    final AbstractPojoHCAnnRawTypeModel<T, ?> declaringTypeModel;
    private final Constructor<T> constructor;
    private List<PojoMethodParameterModel<?>> declaredParameters;
    private ValueCreateHandle<T> handleCache;

    public PojoHCAnnConstructorModel(AbstractPojoHCAnnBootstrapIntrospector introspector, AbstractPojoHCAnnRawTypeModel<T, ?> declaringTypeModel, Constructor<T> constructor) {
        this.introspector = introspector;
        this.declaringTypeModel = declaringTypeModel;
        this.constructor = constructor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.declaringTypeModel.name() + "(" + CommaSeparatedClassesFormatter.format((Class[])this.parametersJavaTypes()) + ")]";
    }

    @Override
    public Stream<Annotation> annotations() {
        return Arrays.stream(this.constructor.getAnnotations());
    }

    @Override
    public PojoRawTypeModel<T> typeModel() {
        return this.declaringTypeModel;
    }

    @Override
    public ValueCreateHandle<T> handle() {
        if (this.handleCache == null) {
            try {
                this.handleCache = this.introspector.createValueCreateHandle(this.constructor);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                throw log.errorRetrievingConstructorHandle(this.constructor, this.declaringTypeModel, e);
            }
        }
        return this.handleCache;
    }

    @Override
    public List<PojoMethodParameterModel<?>> declaredParameters() {
        if (this.declaredParameters == null) {
            this.declaredParameters = new ArrayList();
            Parameter[] parameters = this.constructor.getParameters();
            AnnotatedType[] annotatedTypes = this.constructor.getAnnotatedParameterTypes();
            for (int i = 0; i < parameters.length; ++i) {
                this.declaredParameters.add(new PojoHCAnnMethodParameterModel(this, i, parameters[i], annotatedTypes[i]));
            }
        }
        return this.declaredParameters;
    }

    @Override
    public Class<?>[] parametersJavaTypes() {
        return this.constructor.getParameterTypes();
    }
}

