/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.dependency.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoIndexingDependencyCollectorDirectValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.dependency.PojoOtherEntityIndexingDependencyConfigurationContext;
import org.hibernate.search.mapper.pojo.model.dependency.PojoPropertyIndexingDependencyConfigurationContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.AbstractPojoBridgedElementDependencyContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoOtherEntityIndexingDependencyConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathOriginalTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;

public class PojoPropertyIndexingDependencyConfigurationContextImpl<P>
extends AbstractPojoBridgedElementDependencyContext
implements PojoPropertyIndexingDependencyConfigurationContext {
    private final BoundPojoModelPathPropertyNode<?, P> modelPath;
    private final Map<ContainerExtractorPath, ValueDependencyContext> valueDependencyContexts = new LinkedHashMap<ContainerExtractorPath, ValueDependencyContext>();

    public PojoPropertyIndexingDependencyConfigurationContextImpl(PojoBootstrapIntrospector introspector, ContainerExtractorBinder containerExtractorBinder, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider, BoundPojoModelPathPropertyNode<?, P> modelPath) {
        super(introspector, containerExtractorBinder, typeAdditionalMetadataProvider);
        this.modelPath = modelPath;
    }

    @Override
    public PojoPropertyIndexingDependencyConfigurationContext use(ContainerExtractorPath extractorPathFromBridgedProperty, PojoModelPathValueNode pathFromExtractedBridgedPropertyValueToUsedValue) {
        this.valueDependencyContexts.computeIfAbsent(extractorPathFromBridgedProperty, x$0 -> new ValueDependencyContext((ContainerExtractorPath)x$0)).use(pathFromExtractedBridgedPropertyValueToUsedValue);
        return this;
    }

    @Override
    public PojoOtherEntityIndexingDependencyConfigurationContext fromOtherEntity(ContainerExtractorPath extractorPathFromBridgedProperty, Class<?> otherEntityType, PojoModelPathValueNode pathFromOtherEntityTypeToBridgedPropertyExtractedType) {
        return this.valueDependencyContexts.computeIfAbsent(extractorPathFromBridgedProperty, x$0 -> new ValueDependencyContext((ContainerExtractorPath)x$0)).addOtherEntityDependencyContext(otherEntityType, pathFromOtherEntityTypeToBridgedPropertyExtractedType);
    }

    @Override
    public void useRootOnly() {
        super.useRootOnly();
        ContainerExtractorPath noExtractorPath = ContainerExtractorPath.noExtractors();
        this.valueDependencyContexts.put(noExtractorPath, new ValueDependencyContext(noExtractorPath));
    }

    @Override
    public boolean hasNonRootDependency() {
        if (this.valueDependencyContexts.isEmpty()) {
            return false;
        }
        if (this.valueDependencyContexts.size() > 1) {
            return true;
        }
        ValueDependencyContext noExtractorValue = this.valueDependencyContexts.get(ContainerExtractorPath.noExtractors());
        return noExtractorValue == null || noExtractorValue.hasExplicitDependency();
    }

    public void contributeDependencies(PojoIndexingDependencyCollectorPropertyNode<?, P> dependencyCollector) {
        for (Map.Entry<ContainerExtractorPath, ValueDependencyContext> entry : this.valueDependencyContexts.entrySet()) {
            ContainerExtractorPath extractorPathFromBridgedElement = entry.getKey();
            AbstractPojoIndexingDependencyCollectorDirectValueNode<P, ?> dependencyCollectorValueNode = dependencyCollector.value(extractorPathFromBridgedElement);
            dependencyCollectorValueNode.collectDependency();
            entry.getValue().contributeDependencies(dependencyCollectorValueNode);
        }
    }

    private class ValueDependencyContext {
        private final BoundPojoModelPathOriginalTypeNode<?> valueTypePath;
        private final List<PojoModelPathValueNode> usedPaths = new ArrayList<PojoModelPathValueNode>();
        private final List<PojoOtherEntityIndexingDependencyConfigurationContextImpl<?>> otherEntityDependencyContexts = new ArrayList();

        private ValueDependencyContext(ContainerExtractorPath extractorPathFromBridgedProperty) {
            BoundPojoModelPathValueNode<?, ?, ?> valuePath = PojoPropertyIndexingDependencyConfigurationContextImpl.this.bindingPathWalker.value(PojoPropertyIndexingDependencyConfigurationContextImpl.this.modelPath, extractorPathFromBridgedProperty);
            this.valueTypePath = valuePath.type();
        }

        public void contributeDependencies(AbstractPojoIndexingDependencyCollectorDirectValueNode<?, ?> dependencyCollectorValueNode) {
            PojoIndexingDependencyCollectorTypeNode<?> dependencyCollectorTypeNode = dependencyCollectorValueNode.type();
            for (PojoModelPathValueNode pojoModelPathValueNode : this.usedPaths) {
                PojoModelPathBinder.bind(dependencyCollectorTypeNode, pojoModelPathValueNode, PojoIndexingDependencyCollectorNode.walker());
            }
            for (PojoOtherEntityIndexingDependencyConfigurationContextImpl pojoOtherEntityIndexingDependencyConfigurationContextImpl : this.otherEntityDependencyContexts) {
                pojoOtherEntityIndexingDependencyConfigurationContextImpl.contributeDependencies(dependencyCollectorTypeNode);
            }
        }

        private PojoOtherEntityIndexingDependencyConfigurationContextImpl<?> addOtherEntityDependencyContext(Class<?> otherEntityType, PojoModelPathValueNode pathFromOtherEntityTypeToBridgedPropertyExtractedType) {
            PojoOtherEntityIndexingDependencyConfigurationContextImpl<?> otherContext = PojoPropertyIndexingDependencyConfigurationContextImpl.this.createOtherEntityDependencyContext(this.valueTypePath.getTypeModel().rawType(), otherEntityType, pathFromOtherEntityTypeToBridgedPropertyExtractedType);
            this.otherEntityDependencyContexts.add(otherContext);
            return otherContext;
        }

        public void use(PojoModelPathValueNode pathFromExtractedBridgedPropertyValueToUsedValue) {
            PojoModelPathBinder.bind(this.valueTypePath, pathFromExtractedBridgedPropertyValueToUsedValue, PojoPropertyIndexingDependencyConfigurationContextImpl.this.bindingPathWalker);
            this.usedPaths.add(pathFromExtractedBridgedPropertyValueToUsedValue);
        }

        public boolean hasExplicitDependency() {
            return !this.usedPaths.isEmpty() || !this.otherEntityDependencyContexts.isEmpty();
        }
    }
}

