/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorDisjointValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingDependencyCollectorTypeNode<T>
extends PojoIndexingDependencyCollectorNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractPojoIndexingDependencyCollectorValueNode parentNode;
    private final BoundPojoModelPathTypeNode<T> modelPathFromCurrentNode;
    private final PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode;
    private final BoundPojoModelPathTypeNode<T> modelPathFromLastEntityNode;
    private final ReindexOnUpdate reindexOnUpdate;

    PojoIndexingDependencyCollectorTypeNode(PojoRawTypeModel<T> typeModel, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        this(null, BoundPojoModelPath.root(typeModel), buildingHelper);
    }

    PojoIndexingDependencyCollectorTypeNode(AbstractPojoIndexingDependencyCollectorValueNode parentNode, BoundPojoModelPathTypeNode<T> modelPathFromLastEntityNode, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.parentNode = parentNode;
        PojoTypeModel<T> typeModel = modelPathFromLastEntityNode.getTypeModel();
        this.modelPathFromCurrentNode = BoundPojoModelPath.root(typeModel);
        if (parentNode == null || buildingHelper.isEntity(typeModel.rawType())) {
            this.lastEntityNode = this;
            this.modelPathFromLastEntityNode = this.modelPathFromCurrentNode;
        } else {
            this.lastEntityNode = parentNode.lastEntityNode();
            this.modelPathFromLastEntityNode = modelPathFromLastEntityNode;
        }
        this.reindexOnUpdate = parentNode != null ? parentNode.composeReindexOnUpdate(this.lastEntityNode, null) : buildingHelper.getDefaultReindexOnUpdate();
    }

    public PojoIndexingDependencyCollectorPropertyNode<T, ?> property(String propertyName) {
        return new PojoIndexingDependencyCollectorPropertyNode(this, this.modelPathFromCurrentNode.property(propertyName), this.modelPathFromLastEntityNode.property(propertyName), this.buildingHelper);
    }

    public PojoIndexingDependencyCollectorDisjointValueNode<?> disjointValue(BoundPojoModelPathValueNode<?, ?, ?> inverseAssociationPath) {
        if (this.lastEntityNode != this) {
            throw new AssertionFailure("disjointValue() called on a non-entity node");
        }
        PojoRawTypeModel<?> inverseSideEntityTypeModel = inverseAssociationPath.getRootType().rawType();
        if (!this.buildingHelper.isEntity(inverseAssociationPath.getRootType().rawType())) {
            throw new AssertionFailure("Encountered a type node whose parent is a disjoint value node, but does not represent an entity type?");
        }
        return new PojoIndexingDependencyCollectorDisjointValueNode(this, inverseSideEntityTypeModel, inverseAssociationPath, this.buildingHelper);
    }

    @Override
    PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode() {
        return this.lastEntityNode;
    }

    @Override
    ReindexOnUpdate reindexOnUpdate() {
        return this.reindexOnUpdate;
    }

    void collectDependency(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        if (this.lastEntityNode != this) {
            if (this.parentNode == null) {
                throw new AssertionFailure("collectDependency() called on a non-entity root node?");
            }
            this.parentNode.collectDependency(dirtyPathFromEntityType);
            return;
        }
        PojoRawTypeModel<T> rawType = this.modelPathFromLastEntityNode.getTypeModel().rawType();
        if (this.parentNode == null) {
            PojoImplicitReindexingResolverBuilder<T> builder = this.buildingHelper.getOrCreateResolverBuilder(rawType);
            builder.addDirtyPathTriggeringSelfReindexing(dirtyPathFromEntityType);
        } else {
            for (PojoRawTypeModel<?> concreteEntityType : this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(rawType)) {
                PojoImplicitReindexingResolverOriginalTypeNodeBuilder<?> builder = this.buildingHelper.getOrCreateResolverBuilder(concreteEntityType).containingEntitiesResolverRoot();
                this.parentNode.markForReindexing(builder, dirtyPathFromEntityType);
            }
        }
    }

    void markForReindexing(PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> valueNodeBuilderDelegate, Set<? extends PojoRawTypeModel<?>> valueNodeTypeConcreteEntitySubTypes, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        if (this.lastEntityNode != this) {
            throw new AssertionFailure("markForReindexing() called on a non-entity node");
        }
        if (this.parentNode != null) {
            for (PojoRawTypeModel<?> concreteEntityType : valueNodeTypeConcreteEntitySubTypes) {
                AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseValueTypeBuilder = valueNodeBuilderDelegate.type(concreteEntityType);
                this.parentNode.markForReindexing(inverseValueTypeBuilder, dependencyPathFromInverseSideEntityTypeNode);
            }
        } else {
            for (PojoRawTypeModel<?> concreteEntityType : valueNodeTypeConcreteEntitySubTypes) {
                AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseValueTypeBuilder = valueNodeBuilderDelegate.type(concreteEntityType);
                inverseValueTypeBuilder.addDirtyPathTriggeringReindexing(dependencyPathFromInverseSideEntityTypeNode);
            }
        }
    }

    Set<? extends PojoRawTypeModel<?>> getConcreteEntitySubTypesForTypeToReindex(PojoRawTypeModel<?> originalSideRawType, PojoRawTypeModel<?> inverseSideRawType) {
        if (inverseSideRawType.isSubTypeOf(originalSideRawType)) {
            return this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(inverseSideRawType);
        }
        if (originalSideRawType.isSubTypeOf(inverseSideRawType)) {
            return this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(originalSideRawType);
        }
        throw log.incorrectTargetTypeForInverseAssociation(inverseSideRawType, originalSideRawType);
    }

    PojoTypeModel<T> typeModel() {
        return this.modelPathFromLastEntityNode.getTypeModel();
    }

    List<PojoIndexingDependencyCollectorTypeNode<? extends T>> polymorphic() {
        if (this.parentNode == null || this.lastEntityNode != this) {
            return Collections.singletonList(this);
        }
        PojoRawTypeModel<T> superTypeModel = this.typeModel().rawType();
        ArrayList<PojoIndexingDependencyCollectorTypeNode<T>> result = new ArrayList<PojoIndexingDependencyCollectorTypeNode<T>>();
        for (PojoRawTypeModel<?> concreteSubType : this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(superTypeModel)) {
            result.add(this.castToRawSubType(concreteSubType));
        }
        return result;
    }

    private PojoIndexingDependencyCollectorTypeNode<? extends T> castToRawSubType(PojoRawTypeModel<?> concreteSubType) {
        return new PojoIndexingDependencyCollectorTypeNode<T>(this.parentNode, this.modelPathFromLastEntityNode.castTo(concreteSubType), this.buildingHelper);
    }
}

