/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverCastedTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathFilterProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;

class PojoImplicitReindexingResolverValueNodeBuilderDelegate<V> {
    private final BoundPojoModelPathValueNode<?, ?, V> modelPath;
    private final PojoImplicitReindexingResolverBuildingHelper buildingHelper;
    private PojoImplicitReindexingResolverOriginalTypeNodeBuilder<V> typeNodeBuilder;
    private final Map<PojoRawTypeModel<?>, PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, ?>> castedTypeNodeBuilders = new LinkedHashMap();
    private boolean frozen = false;

    PojoImplicitReindexingResolverValueNodeBuilderDelegate(BoundPojoModelPathValueNode<?, ?, V> modelPath, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        this.modelPath = modelPath;
        this.buildingHelper = buildingHelper;
    }

    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(AbstractPojoImplicitReindexingResolverNodeBuilder::closeOnFailure, this.typeNodeBuilder);
            closer.pushAll(AbstractPojoImplicitReindexingResolverNodeBuilder::closeOnFailure, this.castedTypeNodeBuilders.values());
        }
    }

    PojoTypeModel<V> getTypeModel() {
        return this.modelPath.type().getTypeModel();
    }

    <U> AbstractPojoImplicitReindexingResolverTypeNodeBuilder<V, ?> type(PojoRawTypeModel<U> targetTypeModel) {
        PojoRawTypeModel<V> valueRawTypeModel = this.getTypeModel().rawType();
        if (valueRawTypeModel.isSubTypeOf(targetTypeModel)) {
            return this.type();
        }
        if (targetTypeModel.isSubTypeOf(valueRawTypeModel)) {
            return this.getOrCreateCastedTypeNodeBuilder(targetTypeModel);
        }
        throw new AssertionFailure("Error while building the automatic reindexing resolver at path " + this.modelPath + ": attempt to convert a reindexing resolver builder to an incorrect type;  got " + targetTypeModel + ", but a subtype of " + valueRawTypeModel + " was expected.");
    }

    PojoImplicitReindexingResolverOriginalTypeNodeBuilder<V> type() {
        if (this.typeNodeBuilder == null) {
            this.checkNotFrozen();
            this.typeNodeBuilder = new PojoImplicitReindexingResolverOriginalTypeNodeBuilder<V>(this.modelPath.type(), this.buildingHelper);
        }
        return this.typeNodeBuilder;
    }

    void freeze(Set<PojoModelPathValueNode> dirtyPathsTriggeringReindexingCollector) {
        this.checkNotFrozen();
        if (!this.frozen) {
            this.frozen = true;
            if (this.typeNodeBuilder != null) {
                this.typeNodeBuilder.freeze();
                dirtyPathsTriggeringReindexingCollector.addAll(this.typeNodeBuilder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
            }
            for (PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, ?> builder : this.castedTypeNodeBuilders.values()) {
                builder.freeze();
                dirtyPathsTriggeringReindexingCollector.addAll(builder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
            }
        }
    }

    Collection<PojoImplicitReindexingResolverNode<V>> buildTypeNodes(PojoPathFilterProvider pathFilterProvider, Set<PojoModelPathValueNode> allPotentialDirtyPaths) {
        this.checkFrozen();
        ArrayList<PojoImplicitReindexingResolverNode<V>> immutableTypeNodes = new ArrayList<PojoImplicitReindexingResolverNode<V>>();
        if (this.typeNodeBuilder != null) {
            this.typeNodeBuilder.build(pathFilterProvider, allPotentialDirtyPaths).ifPresent(immutableTypeNodes::add);
        }
        this.castedTypeNodeBuilders.values().stream().map(builder -> builder.build(pathFilterProvider, allPotentialDirtyPaths)).filter(Optional::isPresent).map(Optional::get).forEach(immutableTypeNodes::add);
        return immutableTypeNodes;
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new AssertionFailure("A mutating method was called on " + this + " after it was frozen.");
        }
    }

    final void checkFrozen() {
        if (!this.frozen) {
            throw new AssertionFailure("A method was called on " + this + " before it was frozen, but a preliminary freeze is required.");
        }
    }

    private <U> PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, ? extends U> getOrCreateCastedTypeNodeBuilder(PojoRawTypeModel<U> targetTypeModel) {
        return this.castedTypeNodeBuilders.computeIfAbsent(targetTypeModel, this::createCastedTypeNodeBuilder);
    }

    private <U> PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, ? extends U> createCastedTypeNodeBuilder(PojoRawTypeModel<U> targetTypeModel) {
        this.checkNotFrozen();
        return new PojoImplicitReindexingResolverCastedTypeNodeBuilder<V, U>(this.modelPath.type().castTo(targetTypeModel), this.buildingHelper);
    }
}

