/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.MarkerBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoValueAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoValueAdditionalMetadata;

class PojoPropertyAdditionalMetadataBuilder
implements PojoAdditionalMetadataCollectorPropertyNode {
    private final BeanResolver beanResolver;
    private final Map<ContainerExtractorPath, PojoValueAdditionalMetadataBuilder> valueBuilders = new LinkedHashMap<ContainerExtractorPath, PojoValueAdditionalMetadataBuilder>();
    private final Map<Class<?>, List<?>> markers = new LinkedHashMap();

    PojoPropertyAdditionalMetadataBuilder(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }

    @Override
    public PojoAdditionalMetadataCollectorValueNode value(ContainerExtractorPath extractorPath) {
        return this.valueBuilders.computeIfAbsent(extractorPath, path -> new PojoValueAdditionalMetadataBuilder());
    }

    @Override
    public final void markerBinder(MarkerBinder binder) {
        MarkerBindingContextImpl bindingContext = new MarkerBindingContextImpl(this.beanResolver);
        this.doAddMarker(bindingContext.applyBinder(binder));
    }

    private <M> void doAddMarker(M marker) {
        Class<Object> markerType = marker instanceof Annotation ? ((Annotation)marker).annotationType() : marker.getClass();
        List list = this.markers.computeIfAbsent(markerType, ignored -> new ArrayList());
        list.add(marker);
    }

    PojoPropertyAdditionalMetadata build() {
        HashMap<ContainerExtractorPath, PojoValueAdditionalMetadata> values = new HashMap<ContainerExtractorPath, PojoValueAdditionalMetadata>();
        for (Map.Entry<ContainerExtractorPath, PojoValueAdditionalMetadataBuilder> entry : this.valueBuilders.entrySet()) {
            values.put(entry.getKey(), entry.getValue().build());
        }
        this.markers.replaceAll((key, list) -> Collections.unmodifiableList(list));
        return new PojoPropertyAdditionalMetadata(values, this.markers);
    }
}

