/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeFromDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;

public final class DefaultLocalDateIdentifierBridge
implements IdentifierBridge<LocalDate> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;

    @Override
    public String toDocumentIdentifier(LocalDate propertyValue, IdentifierBridgeToDocumentIdentifierContext context) {
        return FORMATTER.format(propertyValue);
    }

    @Override
    public LocalDate fromDocumentIdentifier(String documentIdentifier, IdentifierBridgeFromDocumentIdentifierContext context) {
        return ParseUtils.parseLocalDate((String)documentIdentifier);
    }

    @Override
    public boolean isCompatibleWith(IdentifierBridge<?> other) {
        return this.getClass().equals(other.getClass());
    }
}

