/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.type.MappingContext;

public final class HibernateOrmMappingPropertiesMetadataContributor
implements PojoTypeMetadataContributor {
    private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
    private final List<Property> properties;

    HibernateOrmMappingPropertiesMetadataContributor(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, List<Property> properties) {
        this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        this.properties = properties;
    }

    public void contributeAdditionalMetadata(PojoAdditionalMetadataCollectorTypeNode collector) {
        for (Property property : this.properties) {
            collector.property(property.getName(), collectorPropertyNode -> this.collectMetadataFromHibernateOrmMappingProperty((PojoAdditionalMetadataCollectorPropertyNode)collectorPropertyNode, property));
        }
    }

    private void collectMetadataFromHibernateOrmMappingProperty(PojoAdditionalMetadataCollectorPropertyNode collector, Property property) {
        Value value = property.getValue();
        if (value instanceof Collection) {
            Collection collectionValue = (Collection)value;
            Value element = collectionValue.getElement();
            String referencedEntityName = this.getReferencedEntityName(element);
            String mappedByPath = collectionValue.getMappedByProperty();
            if (referencedEntityName != null && mappedByPath != null && !mappedByPath.isEmpty()) {
                collector.value(this.getExtractorPath((Value)collectionValue)).associationInverseSide(this.resolveMappedByPath(referencedEntityName, mappedByPath));
            }
        } else if (value instanceof OneToOne) {
            OneToOne toOneValue = (OneToOne)value;
            String referencedEntityName = toOneValue.getReferencedEntityName();
            String mappedByPath = toOneValue.getReferencedPropertyName();
            if (mappedByPath != null && !mappedByPath.isEmpty()) {
                collector.value(this.getExtractorPath((Value)toOneValue)).associationInverseSide(this.resolveMappedByPath(referencedEntityName, mappedByPath));
            }
        } else if (value instanceof Component) {
            collector.value(this.getExtractorPath(value)).associationEmbedded();
        } else if (value instanceof SimpleValue) {
            this.collectScale(collector, value);
        }
    }

    private void collectScale(PojoAdditionalMetadataCollectorPropertyNode collector, Value value) {
        if (value.hasFormula()) {
            return;
        }
        Iterator columnIterator = value.getColumns().iterator();
        Dialect dialect = this.basicTypeMetadataProvider.getDialect();
        Metadata metadata = this.basicTypeMetadataProvider.getMetadata();
        while (columnIterator.hasNext()) {
            Column column = (Column)columnIterator.next();
            Size size = column.getColumnSize(dialect, (MappingContext)metadata);
            Integer scale = size.getScale();
            if (scale == null) continue;
            collector.value(this.getExtractorPath(value)).decimalScale(scale.intValue());
        }
    }

    private String getReferencedEntityName(Value element) {
        if (element instanceof OneToMany) {
            return ((OneToMany)element).getReferencedEntityName();
        }
        if (element instanceof ToOne) {
            return ((ToOne)element).getReferencedEntityName();
        }
        return null;
    }

    private PojoModelPathValueNode resolveMappedByPath(String inverseSideEntity, String mappedByPath) {
        StringTokenizer tokenizer = new StringTokenizer(mappedByPath, ".", false);
        String rootPropertyName = tokenizer.nextToken();
        PojoModelPath.Builder inverseSidePathBuilder = PojoModelPath.builder().property(rootPropertyName);
        Property property = this.basicTypeMetadataProvider.getPersistentClass(inverseSideEntity).getProperty(rootPropertyName);
        do {
            Value value = property.getValue();
            inverseSidePathBuilder.value(this.getExtractorPath(value));
            if (tokenizer.hasMoreTokens()) {
                Component component = (Component)value;
                String propertyName = tokenizer.nextToken();
                property = component.getProperty(propertyName);
                inverseSidePathBuilder.property(propertyName);
                continue;
            }
            property = null;
        } while (property != null);
        return inverseSidePathBuilder.toValuePath();
    }

    private ContainerExtractorPath getExtractorPath(Value value) {
        if (value instanceof Collection) {
            Collection collectionValue = (Collection)value;
            String extractorName = this.getExtractorName(collectionValue);
            return ContainerExtractorPath.explicitExtractor((String)extractorName);
        }
        return ContainerExtractorPath.noExtractors();
    }

    private String getExtractorName(Collection collectionValue) {
        if (collectionValue instanceof Array) {
            return "array-object";
        }
        if (collectionValue instanceof Map) {
            return "map-value";
        }
        return "collection";
    }
}

