/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.mapping.mapper.orm")
@MessageLogger(projectCode="HSEARCH")
public interface MappingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapping.mapper.orm";
    public static final MappingLog INSTANCE = (MappingLog)LoggerFactory.make(MappingLog.class, (String)"org.hibernate.search.mapping.mapper.orm", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=800007, value="Unable to resolve path '%1$s' to a persisted attribute in Hibernate ORM metadata. If this path points to a transient attribute, use @IndexingDependency(derivedFrom = ...) to specify which persisted attributes it is derived from. See the reference documentation for more information.")
    public SearchException unknownPathForDirtyChecking(@FormatWith(value=PojoModelPathFormatter.class) PojoModelPath var1, @Cause Exception var2);

    @Message(id=800008, value="Path '%1$s' points to attribute '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.")
    public SearchException unreportedPathForDirtyChecking(@FormatWith(value=PojoModelPathFormatter.class) PojoModelPath var1, Value var2);

    @Message(id=800009, value="Unable to apply container value extractor with name '%2$s' to Hibernate ORM metadata node of type '%1$s'.")
    public SearchException invalidContainerExtractorForDirtyChecking(Class<?> var1, String var2);

    @Message(id=800012, value="Unable to retrieve property type model for '%1$s' on '%2$s': %3$s")
    public SearchException errorRetrievingPropertyTypeModel(String var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, String var3, @Cause Exception var4);

    @Message(id=800027, value="Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.")
    public SearchException unknownNamedType(String var1, Collection<String> var2);

    @Message(id=800033, value="No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s")
    public SearchException unknownClassForIndexedEntityType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var2);

    @Message(id=800034, value="No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s")
    public SearchException unknownEntityNameForIndexedEntityType(String var1, Collection<String> var2);

    @Message(id=800059, value="No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s")
    public SearchException unknownTypeIdentifierForIndexedEntityType(PojoRawTypeIdentifier<?> var1, Collection<PojoRawTypeIdentifier<?>> var2);

    @Message(id=800060, value="No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s")
    public SearchException unknownClassForMappedEntityType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var2);

    @Message(id=800061, value="No matching entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not mapped in Hibernate Search. Valid names for mapped entity types are: %2$s")
    public SearchException unknownEntityNameForMappedEntityType(String var1, Collection<String> var2);

    @Message(id=800064, value="No matching entity type for name '%1$s'. Either this is not the Hibernate ORM name of an entity type, or the entity type is not mapped in Hibernate Search. Valid Hibernate ORM names for mapped entities are: %2$s")
    public SearchException unknownHibernateOrmEntityNameForMappedEntityType(String var1, Collection<String> var2);

    @Message(id=800121, value="An unexpected failure occurred while resolving the representation of path '%1$s' in the entity state array, which is necessary to configure resolution of association inverse side for reindexing. Cannot proceed further as this may lead to incomplete reindexing and thus out-of-sync indexes. Failure: %3$s %2$s")
    public SearchException failedToResolveStateRepresentation(String var1, @FormatWith(value=EventContextFormatter.class) EventContext var2, String var3, @Cause Exception var4);
}

