/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import jakarta.persistence.EntityGraph;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.search.mapper.orm.loading.spi.EntityGraphHint;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmLoadingMappingContext;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmLoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.spi.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.util.common.impl.Contracts;

public final class HibernateOrmSelectionLoadingContext
implements PojoSelectionLoadingContext {
    private final HibernateOrmLoadingSessionContext sessionContext;
    private final MutableEntityLoadingOptions loadingOptions;
    private final EntityLoadingCacheLookupStrategy cacheLookupStrategy;

    private HibernateOrmSelectionLoadingContext(Builder builder) {
        this.sessionContext = builder.sessionContext;
        this.loadingOptions = builder.loadingOptions;
        this.cacheLookupStrategy = builder.cacheLookupStrategy;
    }

    public void checkOpen() {
        try {
            this.sessionContext.session().checkOpen();
        }
        catch (IllegalStateException e) {
            throw OrmMiscLog.INSTANCE.hibernateSessionIsClosed(e);
        }
    }

    public PojoRuntimeIntrospector runtimeIntrospector() {
        return this.sessionContext.runtimeIntrospector();
    }

    public HibernateOrmLoadingSessionContext sessionContext() {
        return this.sessionContext;
    }

    public SessionImplementor sessionImplementor() {
        return this.sessionContext.session();
    }

    public MutableEntityLoadingOptions loadingOptions() {
        return this.loadingOptions;
    }

    public EntityLoadingCacheLookupStrategy cacheLookupStrategy() {
        return this.cacheLookupStrategy;
    }

    public static final class Builder
    implements PojoSelectionLoadingContextBuilder<SearchLoadingOptionsStep>,
    SearchLoadingOptionsStep {
        private final HibernateOrmLoadingSessionContext sessionContext;
        private final MutableEntityLoadingOptions loadingOptions;
        private EntityLoadingCacheLookupStrategy cacheLookupStrategy;

        public Builder(HibernateOrmLoadingMappingContext mappingContext, HibernateOrmLoadingSessionContext sessionContext) {
            this.sessionContext = sessionContext;
            this.loadingOptions = new MutableEntityLoadingOptions(mappingContext);
            this.cacheLookupStrategy = mappingContext.cacheLookupStrategy();
        }

        public SearchLoadingOptionsStep toAPI() {
            return this;
        }

        @Override
        public SearchLoadingOptionsStep fetchSize(int fetchSize) {
            this.loadingOptions.fetchSize(fetchSize);
            return this;
        }

        @Override
        public SearchLoadingOptionsStep cacheLookupStrategy(EntityLoadingCacheLookupStrategy strategy) {
            this.cacheLookupStrategy = strategy;
            return this;
        }

        @Override
        public SearchLoadingOptionsStep graph(EntityGraph<?> graph, GraphSemantic semantic) {
            this.loadingOptions.entityGraphHint(new EntityGraphHint((RootGraph)graph, semantic), false);
            return this;
        }

        @Override
        public SearchLoadingOptionsStep graph(String graphName, GraphSemantic semantic) {
            Contracts.assertNotNull((Object)graphName, (String)"graphName");
            return this.graph((EntityGraph<?>)this.sessionContext.session().getEntityGraph(graphName), semantic);
        }

        public PojoSelectionLoadingContext build() {
            return new HibernateOrmSelectionLoadingContext(this);
        }
    }
}

