package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.mapping.Value;
import java.util.Collection;
import java.lang.Class;
import java.util.Arrays;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

/**
 * Warning this class consists of generated code.
 */
public class MappingLog_$logger implements MappingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    public MappingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unknownPathForDirtyChecking$str() {
        return "HSEARCH800007: Unable to resolve path '%1$s' to a persisted attribute in Hibernate ORM metadata. If this path points to a transient attribute, use @IndexingDependency(derivedFrom = ...) to specify which persisted attributes it is derived from. See the reference documentation for more information.";
    }
    @Override
    public final SearchException unknownPathForDirtyChecking(final PojoModelPath path, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownPathForDirtyChecking$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unreportedPathForDirtyChecking$str() {
        return "HSEARCH800008: Path '%1$s' points to attribute '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.";
    }
    @Override
    public final SearchException unreportedPathForDirtyChecking(final PojoModelPath path, final Value value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unreportedPathForDirtyChecking$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContainerExtractorForDirtyChecking$str() {
        return "HSEARCH800009: Unable to apply container value extractor with name '%2$s' to Hibernate ORM metadata node of type '%1$s'.";
    }
    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(final Class<?> ormMappingClass, final String extractorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH800012: Unable to retrieve property type model for '%1$s' on '%2$s': %3$s";
    }
    @Override
    public final SearchException errorRetrievingPropertyTypeModel(final String propertyModelName, final PojoRawTypeModel<?> parentTypeModel, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingPropertyTypeModel$str(), propertyModelName, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownNamedType$str() {
        return "HSEARCH800027: Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.";
    }
    @Override
    public final SearchException unknownNamedType(final String typeName, final Collection<String> availableNamedTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNamedType$str(), typeName, availableNamedTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownClassForIndexedEntityType$str() {
        return "HSEARCH800033: No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s";
    }
    @Override
    public final SearchException unknownClassForIndexedEntityType(final Class<?> invalidClass, final Collection<Class<?>> validClasses) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownClassForIndexedEntityType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidClass), new org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter(validClasses)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEntityNameForIndexedEntityType$str() {
        return "HSEARCH800034: No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s";
    }
    @Override
    public final SearchException unknownEntityNameForIndexedEntityType(final String invalidName, final Collection<String> validNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownEntityNameForIndexedEntityType$str(), invalidName, validNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTypeIdentifierForIndexedEntityType$str() {
        return "HSEARCH800059: No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s";
    }
    @Override
    public final SearchException unknownTypeIdentifierForIndexedEntityType(final PojoRawTypeIdentifier<?> invalidTypeId, final Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownTypeIdentifierForIndexedEntityType$str(), invalidTypeId, validTypeIds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownClassForMappedEntityType$str() {
        return "HSEARCH800060: No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s";
    }
    @Override
    public final SearchException unknownClassForMappedEntityType(final Class<?> invalidClass, final Collection<Class<?>> validClasses) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownClassForMappedEntityType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidClass), new org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter(validClasses)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEntityNameForMappedEntityType$str() {
        return "HSEARCH800061: No matching entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not mapped in Hibernate Search. Valid names for mapped entity types are: %2$s";
    }
    @Override
    public final SearchException unknownEntityNameForMappedEntityType(final String invalidName, final Collection<String> validNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownEntityNameForMappedEntityType$str(), invalidName, validNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownHibernateOrmEntityNameForMappedEntityType$str() {
        return "HSEARCH800064: No matching entity type for name '%1$s'. Either this is not the Hibernate ORM name of an entity type, or the entity type is not mapped in Hibernate Search. Valid Hibernate ORM names for mapped entities are: %2$s";
    }
    @Override
    public final SearchException unknownHibernateOrmEntityNameForMappedEntityType(final String invalidName, final Collection<String> validNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownHibernateOrmEntityNameForMappedEntityType$str(), invalidName, validNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToResolveStateRepresentation$str() {
        return "HSEARCH800121: An unexpected failure occurred while resolving the representation of path '%1$s' in the entity state array, which is necessary to configure resolution of association inverse side for reindexing. Cannot proceed further as this may lead to incomplete reindexing and thus out-of-sync indexes. Failure: %3$s %2$s";
    }
    @Override
    public final SearchException failedToResolveStateRepresentation(final String path, final EventContext context, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToResolveStateRepresentation$str(), path, new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
