package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class LoadingLog_$logger extends DelegatingBasicLogger implements LoadingLog, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoadingLog_$logger.class.getName();
    public LoadingLog_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String foundMultipleEntitiesForDocumentId$str() {
        return "HSEARCH800040: Multiple instances of entity type '%1$s' have their property '%2$s' set to '%3$s'. '%2$s' is the document ID and must be assigned unique values.";
    }
    @Override
    public final SearchException foundMultipleEntitiesForDocumentId(final String entityName, final String documentIdSourcePropertyName, final Object id) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), foundMultipleEntitiesForDocumentId$str(), entityName, documentIdSourcePropertyName, id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void numberOfKeysToFetch(final long totalCount) {
        super.log.logf(FQCN, DEBUG, null, numberOfKeysToFetch$str(), totalCount);
    }
    protected String numberOfKeysToFetch$str() {
        return "HSEARCH800134: Going to fetch %d primary keys";
    }
}
