/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.query.impl;

import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.QueryTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.KeyedResultList;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.spi.SearchQueryImplementor;
import org.hibernate.search.mapper.orm.loading.spi.EntityGraphHint;
import org.hibernate.search.mapper.orm.loading.spi.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchQueryAdapterExtension;
import org.hibernate.search.mapper.orm.search.query.spi.HibernateOrmSearchScrollableResultsAdapter;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;

@SuppressForbiddenApis(reason="We need to use the internal QueryOptionsImpl in order to implement a org.hibernate.query.Query")
public final class HibernateOrmSearchQueryAdapter<R>
extends AbstractQuery<R> {
    private final SearchQueryImplementor<R> delegate;
    private final MutableEntityLoadingOptions loadingOptions;

    public static <R> HibernateOrmSearchQueryAdapter<R> create(SearchQuery<R> query) {
        return (HibernateOrmSearchQueryAdapter)((Object)query.extension(HibernateOrmSearchQueryAdapterExtension.get()));
    }

    HibernateOrmSearchQueryAdapter(SearchQueryImplementor<R> delegate, SessionImplementor sessionImplementor, MutableEntityLoadingOptions loadingOptions) {
        super((SharedSessionContractImplementor)sessionImplementor);
        this.delegate = delegate;
        this.loadingOptions = loadingOptions;
    }

    public String toString() {
        return "HibernateOrmSearchQueryAdapter(" + this.getQueryString() + ")";
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.equals(SearchQuery.class)) {
            return (T)this.delegate;
        }
        if (cls.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        throw new PersistenceException("Unrecognized unwrap type [" + cls.getName() + "]");
    }

    public List<R> list() {
        try {
            return super.list();
        }
        catch (SearchTimeoutException e) {
            throw new QueryTimeoutException((Throwable)e);
        }
    }

    public String getQueryString() {
        return this.delegate.queryString();
    }

    public HibernateOrmSearchQueryAdapter<R> setHint(String hintName, Object value) {
        switch (hintName) {
            case "javax.persistence.query.timeout": 
            case "jakarta.persistence.query.timeout": {
                this.delegate.failAfter(HibernateOrmSearchQueryAdapter.hintValueToLong(value), TimeUnit.MILLISECONDS);
                break;
            }
            case "org.hibernate.timeout": {
                this.setTimeout(HibernateOrmSearchQueryAdapter.hintValueToInteger(value));
                break;
            }
            case "javax.persistence.fetchgraph": 
            case "jakarta.persistence.fetchgraph": 
            case "javax.persistence.loadgraph": 
            case "jakarta.persistence.loadgraph": {
                this.applyEntityGraphHint(hintName, value);
                break;
            }
            default: {
                OrmMiscLog.INSTANCE.ignoringUnrecognizedQueryHint(hintName);
            }
        }
        return this;
    }

    public HibernateOrmSearchQueryAdapter<R> setTimeout(int timeout) {
        this.delegate.failAfter(Long.valueOf(timeout), TimeUnit.SECONDS);
        return this;
    }

    public HibernateOrmSearchQueryAdapter<R> setTimeout(Integer timeout) {
        this.delegate.failAfter(timeout == null ? null : Long.valueOf(timeout.longValue()), TimeUnit.SECONDS);
        return this;
    }

    public HibernateOrmSearchQueryAdapter<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    public ScrollableResultsImplementor<R> scroll() {
        return this.scroll(ScrollMode.FORWARD_ONLY);
    }

    public long getResultCount() {
        return this.delegate.fetchTotalHitCount();
    }

    public KeyedResultList<R> getKeyedResultList(KeyedPage<R> page) {
        throw this.keyedResultListNoSupported();
    }

    private UnsupportedOperationException keyedResultListNoSupported() {
        return new UnsupportedOperationException("Keyed result lists are not supported in Hibernate Search queries");
    }

    protected ScrollableResultsImplementor<R> doScroll(ScrollMode scrollMode) {
        if (!ScrollMode.FORWARD_ONLY.equals((Object)scrollMode)) {
            throw OrmMiscLog.INSTANCE.canOnlyUseScrollWithScrollModeForwardsOnly(scrollMode);
        }
        int chunkSize = this.loadingOptions.fetchSize();
        return new HibernateOrmSearchScrollableResultsAdapter(this.delegate.scroll(chunkSize), this.getMaxResults(), Function.identity());
    }

    protected List<R> doList() {
        Integer limit = this.getQueryOptions().getLimit().getMaxRows();
        Integer offset = this.getQueryOptions().getLimit().getFirstRow();
        return this.delegate.fetchHits(offset, limit);
    }

    protected void beforeQuery() {
        super.beforeQuery();
        this.extractQueryOptions();
    }

    private void extractQueryOptions() {
        AppliedGraph appliedGraph;
        RootGraphImplementor graph;
        Integer queryTimeout;
        MutableQueryOptions queryOptions = this.getQueryOptions();
        Integer queryFetchSize = queryOptions.getFetchSize();
        if (queryFetchSize != null) {
            this.loadingOptions.fetchSize(queryFetchSize);
        }
        if ((queryTimeout = queryOptions.getTimeout()) != null) {
            this.delegate.failAfter(Long.valueOf(queryTimeout.intValue()), TimeUnit.SECONDS);
        }
        EntityGraphHint entityGraphHint = null;
        if (HibernateOrmSearchQueryAdapter.isGraphApplied(queryOptions) && (graph = (appliedGraph = queryOptions.getAppliedGraph()).getGraph()) != null) {
            entityGraphHint = new EntityGraphHint(graph, appliedGraph.getSemantic());
        }
        this.loadingOptions.entityGraphHint(entityGraphHint, true);
    }

    public Map<String, Object> getHints() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ParameterMetadataImplementor getParameterMetadata() {
        throw this.parametersNoSupported();
    }

    public QueryParameterBindings getParameterBindings() {
        return QueryParameterBindings.empty();
    }

    public QueryParameterBindings getQueryParameterBindings() {
        return QueryParameterBindings.empty();
    }

    protected <P> QueryParameterBinding<P> locateBinding(String name) {
        throw this.parametersNoSupported();
    }

    protected <P> QueryParameterBinding<P> locateBinding(int position) {
        throw this.parametersNoSupported();
    }

    protected <P> QueryParameterBinding<P> locateBinding(Parameter<P> parameter) {
        throw this.parametersNoSupported();
    }

    protected <P> QueryParameterBinding<P> locateBinding(QueryParameterImplementor<P> parameter) {
        throw this.parametersNoSupported();
    }

    private UnsupportedOperationException parametersNoSupported() {
        return new UnsupportedOperationException("Parameters are not supported in Hibernate Search queries");
    }

    public <T> QueryImplementor<T> setTupleTransformer(TupleTransformer<T> transformer) {
        throw this.resultOrTupleTransformerNotImplemented();
    }

    public QueryImplementor<R> setResultListTransformer(ResultListTransformer<R> resultListTransformer) {
        throw this.resultOrTupleTransformerNotImplemented();
    }

    private UnsupportedOperationException resultOrTupleTransformerNotImplemented() {
        return new UnsupportedOperationException("Result transformers are not supported in Hibernate Search queries");
    }

    public HibernateOrmSearchQueryAdapter<R> setLockMode(LockModeType lockModeType) {
        throw this.lockOptionsNotSupported();
    }

    public LockModeType getLockMode() {
        throw this.lockOptionsNotSupported();
    }

    public LockOptions getLockOptions() {
        return null;
    }

    private UnsupportedOperationException lockOptionsNotSupported() {
        return new UnsupportedOperationException("Lock options are not supported in Hibernate Search queries");
    }

    public int executeUpdate() throws HibernateException {
        return this.doExecuteUpdate();
    }

    protected int doExecuteUpdate() {
        throw new UnsupportedOperationException("executeUpdate() is not supported in Hibernate Search queries");
    }

    public HibernateOrmSearchQueryAdapter<R> setLockMode(String alias, LockMode lockMode) {
        throw this.lockOptionsNotSupported();
    }

    private static Long hintValueToLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(String.valueOf(value));
    }

    private static Integer hintValueToInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    private static boolean isGraphApplied(MutableQueryOptions queryOptions) {
        AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
        return appliedGraph != null && appliedGraph.getSemantic() != null;
    }
}

