/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.orm.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class MappingLog_$logger
implements MappingLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public MappingLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unknownPathForDirtyChecking$str() {
        return "HSEARCH800007: Unable to resolve path '%1$s' to a persisted attribute in Hibernate ORM metadata. If this path points to a transient attribute, use @IndexingDependency(derivedFrom = ...) to specify which persisted attributes it is derived from. See the reference documentation for more information.";
    }

    @Override
    public final SearchException unknownPathForDirtyChecking(PojoModelPath path, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownPathForDirtyChecking$str(), new PojoModelPathFormatter(path)), (Throwable)e);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unreportedPathForDirtyChecking$str() {
        return "HSEARCH800008: Path '%1$s' points to attribute '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.";
    }

    @Override
    public final SearchException unreportedPathForDirtyChecking(PojoModelPath path, Value value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unreportedPathForDirtyChecking$str(), new PojoModelPathFormatter(path), value));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidContainerExtractorForDirtyChecking$str() {
        return "HSEARCH800009: Unable to apply container value extractor with name '%2$s' to Hibernate ORM metadata node of type '%1$s'.";
    }

    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(Class<?> ormMappingClass, String extractorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH800012: Unable to retrieve property type model for '%1$s' on '%2$s': %3$s";
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel), causeMessage), (Throwable)cause);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownNamedType$str() {
        return "HSEARCH800027: Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.";
    }

    @Override
    public final SearchException unknownNamedType(String typeName, Collection<String> availableNamedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNamedType$str(), typeName, availableNamedTypes));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownClassForIndexedEntityType$str() {
        return "HSEARCH800033: No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownClassForIndexedEntityType(Class<?> invalidClass, Collection<Class<?>> validClasses) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownClassForIndexedEntityType$str(), new ClassFormatter(invalidClass), new CommaSeparatedClassesFormatter(validClasses)));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownEntityNameForIndexedEntityType$str() {
        return "HSEARCH800034: No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownEntityNameForIndexedEntityType(String invalidName, Collection<String> validNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownEntityNameForIndexedEntityType$str(), invalidName, validNames));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownTypeIdentifierForIndexedEntityType$str() {
        return "HSEARCH800059: No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownTypeIdentifierForIndexedEntityType(PojoRawTypeIdentifier<?> invalidTypeId, Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownTypeIdentifierForIndexedEntityType$str(), invalidTypeId, validTypeIds));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownClassForMappedEntityType$str() {
        return "HSEARCH800060: No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s";
    }

    @Override
    public final SearchException unknownClassForMappedEntityType(Class<?> invalidClass, Collection<Class<?>> validClasses) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownClassForMappedEntityType$str(), new ClassFormatter(invalidClass), new CommaSeparatedClassesFormatter(validClasses)));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownEntityNameForMappedEntityType$str() {
        return "HSEARCH800061: No matching entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not mapped in Hibernate Search. Valid names for mapped entity types are: %2$s";
    }

    @Override
    public final SearchException unknownEntityNameForMappedEntityType(String invalidName, Collection<String> validNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownEntityNameForMappedEntityType$str(), invalidName, validNames));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownHibernateOrmEntityNameForMappedEntityType$str() {
        return "HSEARCH800064: No matching entity type for name '%1$s'. Either this is not the Hibernate ORM name of an entity type, or the entity type is not mapped in Hibernate Search. Valid Hibernate ORM names for mapped entities are: %2$s";
    }

    @Override
    public final SearchException unknownHibernateOrmEntityNameForMappedEntityType(String invalidName, Collection<String> validNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownHibernateOrmEntityNameForMappedEntityType$str(), invalidName, validNames));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToResolveStateRepresentation$str() {
        return "HSEARCH800121: An unexpected failure occurred while resolving the representation of path '%1$s' in the entity state array, which is necessary to configure resolution of association inverse side for reindexing. Cannot proceed further as this may lead to incomplete reindexing and thus out-of-sync indexes. Failure: %3$s %2$s";
    }

    @Override
    public final SearchException failedToResolveStateRepresentation(String path, EventContext context, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToResolveStateRepresentation$str(), path, new EventContextFormatter(context), causeMessage), (Throwable)cause);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

