/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.common.impl;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.models.internal.ClassLoaderServiceLoading;
import org.hibernate.boot.models.internal.ModelsHelper;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.models.internal.BasicModelBuildingContextImpl;
import org.hibernate.models.jandex.internal.JandexModelBuildingContextImpl;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.common.impl.PropertyComparator;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.jandex.IndexView;

public final class HibernateOrmUtils {
    private HibernateOrmUtils() {
    }

    public static SessionFactoryImplementor toSessionFactoryImplementor(EntityManagerFactory entityManagerFactory) {
        try {
            return (SessionFactoryImplementor)entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        }
        catch (IllegalStateException e) {
            throw OrmMiscLog.INSTANCE.hibernateSessionFactoryAccessError(e.getMessage(), e);
        }
    }

    public static Session toSession(EntityManager entityManager) {
        try {
            return (Session)entityManager.unwrap(Session.class);
        }
        catch (IllegalStateException e) {
            throw OrmMiscLog.INSTANCE.hibernateSessionAccessError(e.getMessage(), e);
        }
    }

    public static SessionImplementor toSessionImplementor(EntityManager entityManager) {
        try {
            return (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        }
        catch (IllegalStateException e) {
            throw OrmMiscLog.INSTANCE.hibernateSessionAccessError(e.getMessage(), e);
        }
    }

    private static boolean isSuperTypeOf(EntityMappingType type1, EntityMappingType type2) {
        return type1.getSubclassEntityNames().contains(type2.getEntityName());
    }

    public static EntityMappingType entityMappingType(SessionFactoryImplementor sessionFactory, String entityName) {
        MappingMetamodelImplementor metamodel = sessionFactory.getMappingMetamodel();
        return metamodel.getEntityDescriptor(entityName);
    }

    public static EntityDomainType<?> entityDomainType(SessionFactoryImplementor sessionFactory, String entityName) {
        JpaMetamodel metamodel = sessionFactory.getJpaMetamodel();
        return metamodel.entity(entityName);
    }

    public static Class<?> entityClass(PersistentClass persistentClass) {
        if (persistentClass.hasPojoRepresentation()) {
            return persistentClass.getMappedClass();
        }
        return Map.class;
    }

    public static EntityMappingType toMostSpecificCommonEntitySuperType(EntityMappingType type1, EntityMappingType type2) {
        EntityMappingType superTypeCandidate;
        for (superTypeCandidate = type1; superTypeCandidate != null && !HibernateOrmUtils.isSuperTypeOf(superTypeCandidate, type2); superTypeCandidate = superTypeCandidate.getSuperMappingType()) {
        }
        if (superTypeCandidate == null) {
            throw new AssertionFailure("Cannot find a common entity supertype for " + type1.getEntityName() + " and " + type2.getEntityName() + ".");
        }
        return superTypeCandidate;
    }

    public static boolean targetsAllConcreteSubTypes(SessionFactoryImplementor sessionFactory, EntityMappingType commonSupertype, Collection<? extends PojoLoadingTypeContext<?>> targetConcreteSubTypes) {
        Set subClassEntityNames = commonSupertype.getSubclassEntityNames();
        if (subClassEntityNames.size() == targetConcreteSubTypes.size()) {
            return true;
        }
        MappingMetamodelImplementor metamodel = sessionFactory.getMappingMetamodel();
        int concreteSubTypesCount = 0;
        for (String subClassEntityName : subClassEntityNames) {
            EntityPersister subclassType = metamodel.getEntityDescriptor(subClassEntityName);
            if (subclassType.isAbstract()) continue;
            ++concreteSubTypesCount;
        }
        return concreteSubTypesCount == targetConcreteSubTypes.size();
    }

    @SuppressForbiddenApis(reason="Safer wrapper")
    public static <T extends Service> T getServiceOrFail(ServiceRegistry serviceRegistry, Class<T> serviceClass) {
        Service service = serviceRegistry.getService(serviceClass);
        if (service == null) {
            throw new AssertionFailure("A required service was missing. Missing service: " + String.valueOf(serviceClass));
        }
        return (T)service;
    }

    @SuppressForbiddenApis(reason="Safer wrapper")
    public static <T extends Service> Optional<T> getServiceOrEmpty(ServiceRegistry serviceRegistry, Class<T> serviceClass) {
        ServiceBinding binding = ((ServiceRegistryImplementor)serviceRegistry).locateServiceBinding(serviceClass);
        if (binding == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(serviceRegistry.getService(serviceClass));
    }

    public static List<Property> sortedNonSyntheticProperties(Iterator<Property> propertyIterator) {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            if (property.isSynthetic()) continue;
            properties.add(property);
        }
        properties.sort(PropertyComparator.INSTANCE);
        return properties;
    }

    public static boolean isDiscriminatorMultiTenancyEnabled(Metadata metadata) {
        return metadata.getFilterDefinition("_tenantId") != null;
    }

    public static SourceModelBuildingContext createModelBuildingContext(BootstrapContext bootstrapContext) {
        ClassLoaderService classLoaderService = HibernateOrmUtils.getServiceOrEmpty((ServiceRegistry)bootstrapContext.getServiceRegistry(), ClassLoaderService.class).orElseThrow();
        ClassLoaderServiceLoading classLoading = new ClassLoaderServiceLoading(classLoaderService);
        if (bootstrapContext.getJandexView() == null) {
            return new BasicModelBuildingContextImpl((ClassLoading)classLoading, ModelsHelper::preFillRegistries);
        }
        return new JandexModelBuildingContextImpl((IndexView)bootstrapContext.getJandexView(), (ClassLoading)classLoading, ModelsHelper::preFillRegistries);
    }
}

