/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.spi;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.logging.impl.ConfigurationLog;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;

public final class BackendsInfo {
    private final Map<Optional<String>, BackendInfo> backendsByNames = new LinkedHashMap<Optional<String>, BackendInfo>();

    public Collection<BackendInfo> values() {
        return this.backendsByNames.values();
    }

    public void collect(Optional<String> name, TenancyMode tenancyMode) {
        this.backendsByNames.merge(name, new BackendInfo(name, tenancyMode), (info1, info2) -> {
            if (info1.tenancyMode == info2.tenancyMode) {
                return info1;
            }
            if (name.isPresent()) {
                throw ConfigurationLog.INSTANCE.differentMultiTenancyNamedBackend((String)name.get());
            }
            throw ConfigurationLog.INSTANCE.differentMultiTenancyDefaultBackend();
        });
    }

    public static final class BackendInfo {
        private final Optional<String> name;
        private final TenancyMode tenancyMode;

        public BackendInfo(Optional<String> name, TenancyMode tenancyMode) {
            this.name = name;
            this.tenancyMode = tenancyMode;
        }

        public Optional<String> name() {
            return this.name;
        }

        public TenancyMode tenancyStrategy() {
            return this.tenancyMode;
        }
    }
}

