package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import org.hibernate.search.engine.search.common.RewriteMethod;
import org.hibernate.search.util.common.SearchException;
import java.time.Duration;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.SearchTimeoutException;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;

/**
 * Warning this class consists of generated code.
 */
public class QueryLog_$logger implements QueryLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = QueryLog_$logger.class.getName();
    public QueryLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String rangePredicateCannotMatchNullValue$str() {
        return "HSEARCH000237: Invalid range: at least one bound in range predicates must be non-null.";
    }
    @Override
    public final SearchException rangePredicateCannotMatchNullValue(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangePredicateCannotMatchNullValue$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String perFieldBoostWithConstantScore$str() {
        return "HSEARCH000551: Invalid use of per-field boost: the predicate score is constant. Cannot assign a different boost to each field when the predicate score is constant.";
    }
    @Override
    public final SearchException perFieldBoostWithConstantScore() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), perFieldBoostWithConstantScore$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPhrasePredicateSlop$str() {
        return "HSEARCH000553: Invalid slop: %1$d. The slop must be positive or zero.";
    }
    @Override
    public final SearchException invalidPhrasePredicateSlop(final int slop) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPhrasePredicateSlop$str(), slop));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFuzzyMaximumEditDistance$str() {
        return "HSEARCH000554: Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.";
    }
    @Override
    public final SearchException invalidFuzzyMaximumEditDistance(final int maximumEditDistance) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFuzzyMaximumEditDistance$str(), maximumEditDistance));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidExactPrefixLength$str() {
        return "HSEARCH000555: Invalid exact prefix length: %1$d. The value must be positive or zero.";
    }
    @Override
    public final SearchException invalidExactPrefixLength(final int exactPrefixLength) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidExactPrefixLength$str(), exactPrefixLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonSingleHit$str() {
        return "HSEARCH000561: Multiple hits when a single hit was expected.";
    }
    @Override
    public final SearchException nonSingleHit() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonSingleHit$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAggregationKey$str() {
        return "HSEARCH000565: Unknown aggregation key '%1$s'. This key was not used when building the search query.";
    }
    @Override
    public final SearchException unknownAggregationKey(final AggregationKey<?> key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownAggregationKey$str(), key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedMultiValuedField$str() {
        return "HSEARCH000572: Inconsistent index data: a supposedly single-valued field returned multiple values. Values: [%1$s, %2$s].";
    }
    @Override
    public final SearchException unexpectedMultiValuedField(final Object value1, final Object value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedMultiValuedField$str(), value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDslArgumentType$str() {
        return "HSEARCH000583: Invalid type for DSL arguments: '%1$s'. Expected '%2$s' or a subtype.";
    }
    @Override
    public final SearchException invalidDslArgumentType(final Class<?> type, final Class<?> correctType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDslArgumentType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), new org.hibernate.search.util.common.logging.impl.ClassFormatter(correctType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidReturnType$str() {
        return "HSEARCH000584: Invalid type for returned values: '%1$s'. Expected '%2$s' or a supertype.";
    }
    @Override
    public final SearchException invalidReturnType(final Class<?> type, final Class<?> correctType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidReturnType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), new org.hibernate.search.util.common.logging.impl.ClassFormatter(correctType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timedOut$str() {
        return "HSEARCH000586: Operation exceeded the timeout of %1$s.";
    }
    @Override
    public final SearchTimeoutException timedOut(final Duration timeout, final Exception cause) {
        final SearchTimeoutException result = new SearchTimeoutException(String.format(getLoggingLocale(), timedOut$str(), new org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter(timeout)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notExactTotalHitCount$str() {
        return "HSEARCH000587: Unable to provide the exact total hit count: only a lower-bound approximation is available. This is generally the result of setting query options such as a timeout or the total hit count threshold. Either unset these options, or retrieve the lower-bound hit count approximation through '.total().hitCountLowerBound()'.";
    }
    @Override
    public final SearchException notExactTotalHitCount() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notExactTotalHitCount$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inconsistentConfigurationInContextForSearch$str() {
        return "HSEARCH000601: Inconsistent configuration for %1$s in a search query across multiple indexes: %2$s";
    }
    @Override
    public final SearchException inconsistentConfigurationInContextForSearch(final EventContext elementContext, final String causeMessage, final EventContext elementContextAsParam, final SearchException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), inconsistentConfigurationInContextForSearch$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext), causeMessage), cause, elementContextAsParam);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inconsistentSupportForQueryElement$str() {
        return "HSEARCH000602: Inconsistent support for '%1$s': %2$s";
    }
    @Override
    public final SearchException inconsistentSupportForQueryElement(final SearchQueryElementTypeKey<?> key, final String causeMessage, final SearchException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), inconsistentSupportForQueryElement$str(), key, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentAttribute$str() {
        return "HSEARCH000603: Attribute '%1$s' differs: '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException differentAttribute(final String attributeName, final Object component1, final Object component2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentAttribute$str(), attributeName, component1, component2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseQueryElementForIndexNode$str() {
        return "HSEARCH000604: Cannot use '%2$s' on %1$s: %3$s";
    }
    @Override
    public final SearchException cannotUseQueryElementForIndexNode(final EventContext elementContext, final SearchQueryElementTypeKey<?> key, final String hint, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseQueryElementForIndexNode$str(), new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(elementContext), key, hint), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String partialSupportForQueryElement$str() {
        return "HSEARCH000606: '%1$s' can be used in some of the targeted indexes, but not all of them. %2$s";
    }
    @Override
    public final SearchException partialSupportForQueryElement(final SearchQueryElementTypeKey<?> key, final String hint) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), partialSupportForQueryElement$str(), key, hint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldModel$str() {
        return "HSEARCH000609: This field is a value field in some indexes, but an object field in other indexes.";
    }
    @Override
    public final SearchException conflictingFieldModel() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldModel$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForSearch$str() {
        return "HSEARCH000610: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForSearch(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForSearch$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String targetFieldsSpanningMultipleNestedPaths$str() {
        return "HSEARCH000611: Invalid target fields: fields [%1$s, %3$s] are in different nested documents (%2$s vs. %4$s). All target fields must be in the same document.";
    }
    @Override
    public final SearchException targetFieldsSpanningMultipleNestedPaths(final String fieldPath1, final EventContext nestedPath1, final String fieldPath2, final EventContext nestedPath2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), targetFieldsSpanningMultipleNestedPaths$str(), fieldPath1, new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(nestedPath1), fieldPath2, new org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter(nestedPath2)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateEntityProjection$str() {
        return "HSEARCH000614: Cannot project on entity type '%1$s': this type cannot be loaded from an external datasource, and the documents from the index cannot be projected to its Java class '%2$s'. %3$s";
    }
    @Override
    public final SearchException cannotCreateEntityProjection(final String name, final Class<?> javaClass, final String hint) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateEntityProjection$str(), name, new org.hibernate.search.util.common.logging.impl.ClassFormatter(javaClass), hint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTypeForEntityProjection$str() {
        return "HSEARCH000618: Invalid type for entity projection on type '%1$s': the entity type's Java class '%2$s' does not extend the requested projection type '%3$s'.";
    }
    @Override
    public final SearchException invalidTypeForEntityProjection(final String name, final Class<?> entityType, final Class<?> requestedEntityType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTypeForEntityProjection$str(), name, new org.hibernate.search.util.common.logging.impl.ClassFormatter(entityType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedEntityType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parameterizedRewriteMethodWithoutParameter$str() {
        return "HSEARCH000621: Cannot use rewrite method '%1$s': this method requires parameter 'n', which was not specified. Use another version of the rewrite(...) method that accepts parameter 'n'.";
    }
    @Override
    public final SearchException parameterizedRewriteMethodWithoutParameter(final RewriteMethod rewriteMethod) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), parameterizedRewriteMethodWithoutParameter$str(), rewriteMethod));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonParameterizedRewriteMethodWithParameter$str() {
        return "HSEARCH000622: Cannot use rewrite method '%1$s': this method does not accept parameter 'n', but it was specified. Use another version of the rewrite(...) method that does not accept parameter 'n'.";
    }
    @Override
    public final SearchException nonParameterizedRewriteMethodWithParameter(final RewriteMethod rewriteMethod) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonParameterizedRewriteMethodWithParameter$str(), rewriteMethod));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindQueryParameter$str() {
        return "HSEARCH000624: Query parameter '%1$s' is not set. Use `.param(..)` methods on the query to set any parameters that the query requires.";
    }
    @Override
    public final SearchException cannotFindQueryParameter(final String parameter) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindQueryParameter$str(), parameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedQueryParameterType$str() {
        return "HSEARCH000625: Expecting value of query parameter '%1$s' to be of type %2$s, but instead got a value of type %3$s.";
    }
    @Override
    public final SearchException unexpectedQueryParameterType(final String name, final Class<?> expected, final Class<?> actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedQueryParameterType$str(), name, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expected), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actual)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String namedValuesParameterNotDefined$str() {
        return "HSEARCH000626: Named value '%1$s' has not been defined.";
    }
    @Override
    public final SearchException namedValuesParameterNotDefined(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), namedValuesParameterNotDefined$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String namedValuesParameterIncorrectType$str() {
        return "HSEARCH000627: Expecting value of named value '%1$s' to be of type %2$s, but instead got a value of type %3$s.";
    }
    @Override
    public final SearchException namedValuesParameterIncorrectType(final String name, final Class<?> expected, final Class<?> actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), namedValuesParameterIncorrectType$str(), name, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expected), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actual)));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
