/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.common.RewriteMethod;
import org.hibernate.search.engine.search.predicate.dsl.QueryStringPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.QueryStringPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractStringQueryPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.CommonQueryStringPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.QueryStringPredicateBuilder;

class QueryStringPredicateFieldMoreStepImpl
implements QueryStringPredicateFieldMoreStep<QueryStringPredicateFieldMoreStepImpl, QueryStringPredicateOptionsStep<?>> {
    private final CommonState commonState;
    private final List<CommonQueryStringPredicateBuilder.FieldState> fieldStates = new ArrayList<CommonQueryStringPredicateBuilder.FieldState>();

    QueryStringPredicateFieldMoreStepImpl(CommonState commonState, List<String> fieldPaths) {
        this.commonState = commonState;
        for (String fieldPath : fieldPaths) {
            this.fieldStates.add(commonState.field(fieldPath));
        }
    }

    @Override
    public QueryStringPredicateFieldMoreStepImpl fields(String ... fieldPaths) {
        return new QueryStringPredicateFieldMoreStepImpl(this.commonState, Arrays.asList(fieldPaths));
    }

    @Override
    public QueryStringPredicateFieldMoreStepImpl boost(float boost) {
        this.fieldStates.forEach(c -> c.boost(boost));
        return this;
    }

    @Override
    public QueryStringPredicateOptionsStep<?> matching(String queryString) {
        return (QueryStringPredicateOptionsStep)this.commonState.matching(queryString);
    }

    static class CommonState
    extends AbstractStringQueryPredicateCommonState<CommonState, QueryStringPredicateOptionsStep<CommonState>, QueryStringPredicateBuilder>
    implements QueryStringPredicateOptionsStep<CommonState> {
        private static final Set<RewriteMethod> PARAMETERIZED_REWRITE_METHODS = EnumSet.of(RewriteMethod.TOP_TERMS_BOOST_N, RewriteMethod.TOP_TERMS_BLENDED_FREQS_N, RewriteMethod.TOP_TERMS_N);

        CommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        @Override
        protected QueryStringPredicateBuilder createBuilder(SearchPredicateDslContext<?> dslContext) {
            return dslContext.scope().predicateBuilders().queryString();
        }

        @Override
        public CommonState allowLeadingWildcard(boolean allowLeadingWildcard) {
            ((QueryStringPredicateBuilder)this.builder).allowLeadingWildcard(allowLeadingWildcard);
            return this;
        }

        @Override
        public CommonState enablePositionIncrements(boolean enablePositionIncrements) {
            ((QueryStringPredicateBuilder)this.builder).enablePositionIncrements(enablePositionIncrements);
            return this;
        }

        @Override
        public CommonState phraseSlop(Integer phraseSlop) {
            ((QueryStringPredicateBuilder)this.builder).phraseSlop(phraseSlop);
            return this;
        }

        @Override
        public CommonState rewriteMethod(RewriteMethod rewriteMethod) {
            if (PARAMETERIZED_REWRITE_METHODS.contains((Object)rewriteMethod)) {
                throw QueryLog.INSTANCE.parameterizedRewriteMethodWithoutParameter(rewriteMethod);
            }
            ((QueryStringPredicateBuilder)this.builder).rewriteMethod(rewriteMethod, null);
            return this;
        }

        @Override
        public CommonState rewriteMethod(RewriteMethod rewriteMethod, int n) {
            if (!PARAMETERIZED_REWRITE_METHODS.contains((Object)rewriteMethod)) {
                throw QueryLog.INSTANCE.nonParameterizedRewriteMethodWithParameter(rewriteMethod);
            }
            ((QueryStringPredicateBuilder)this.builder).rewriteMethod(rewriteMethod, n);
            return this;
        }

        @Override
        protected CommonState thisAsT() {
            return this;
        }
    }
}

