/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.common.RewriteMethod;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.query", description="Logs related to the queries.")
@MessageLogger(projectCode="HSEARCH")
public interface QueryLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.query";
    public static final QueryLog INSTANCE = (QueryLog)LoggerFactory.make(QueryLog.class, (String)"org.hibernate.search.query", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=237, value="Invalid range: at least one bound in range predicates must be non-null.")
    public SearchException rangePredicateCannotMatchNullValue(@Param EventContext var1);

    @Message(id=551, value="Invalid use of per-field boost: the predicate score is constant. Cannot assign a different boost to each field when the predicate score is constant.")
    public SearchException perFieldBoostWithConstantScore();

    @Message(id=553, value="Invalid slop: %1$d. The slop must be positive or zero.")
    public SearchException invalidPhrasePredicateSlop(int var1);

    @Message(id=554, value="Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.")
    public SearchException invalidFuzzyMaximumEditDistance(int var1);

    @Message(id=555, value="Invalid exact prefix length: %1$d. The value must be positive or zero.")
    public SearchException invalidExactPrefixLength(int var1);

    @Message(id=561, value="Multiple hits when a single hit was expected.")
    public SearchException nonSingleHit();

    @Message(id=565, value="Unknown aggregation key '%1$s'. This key was not used when building the search query.")
    public SearchException unknownAggregationKey(AggregationKey<?> var1);

    @Message(id=572, value="Inconsistent index data: a supposedly single-valued field returned multiple values. Values: [%1$s, %2$s].")
    public SearchException unexpectedMultiValuedField(Object var1, Object var2);

    @Message(id=583, value="Invalid type for DSL arguments: '%1$s'. Expected '%2$s' or a subtype.")
    public SearchException invalidDslArgumentType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=584, value="Invalid type for returned values: '%1$s'. Expected '%2$s' or a supertype.")
    public SearchException invalidReturnType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=586, value="Operation exceeded the timeout of %1$s.")
    public SearchTimeoutException timedOut(@FormatWith(value=DurationInSecondsAndFractionsFormatter.class) Duration var1, @Cause Exception var2);

    @Message(id=587, value="Unable to provide the exact total hit count: only a lower-bound approximation is available. This is generally the result of setting query options such as a timeout or the total hit count threshold. Either unset these options, or retrieve the lower-bound hit count approximation through '.total().hitCountLowerBound()'.")
    public SearchException notExactTotalHitCount();

    @Message(id=601, value="Inconsistent configuration for %1$s in a search query across multiple indexes: %2$s")
    public SearchException inconsistentConfigurationInContextForSearch(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1, String var2, @Param EventContext var3, @Cause SearchException var4);

    @Message(id=602, value="Inconsistent support for '%1$s': %2$s")
    public SearchException inconsistentSupportForQueryElement(SearchQueryElementTypeKey<?> var1, String var2, @Cause SearchException var3);

    @Message(id=603, value="Attribute '%1$s' differs: '%2$s' vs. '%3$s'.")
    public SearchException differentAttribute(String var1, Object var2, Object var3);

    @Message(id=604, value="Cannot use '%2$s' on %1$s: %3$s")
    public SearchException cannotUseQueryElementForIndexNode(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1, SearchQueryElementTypeKey<?> var2, String var3, @Param EventContext var4, @Cause Exception var5);

    @Message(id=606, value="'%1$s' can be used in some of the targeted indexes, but not all of them. %2$s")
    public SearchException partialSupportForQueryElement(SearchQueryElementTypeKey<?> var1, String var2);

    @Message(id=609, value="This field is a value field in some indexes, but an object field in other indexes.")
    public SearchException conflictingFieldModel();

    @Message(id=610, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForSearch(String var1, @Param EventContext var2);

    @Message(id=611, value="Invalid target fields: fields [%1$s, %3$s] are in different nested documents (%2$s vs. %4$s). All target fields must be in the same document.")
    public SearchException targetFieldsSpanningMultipleNestedPaths(String var1, @FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var2, String var3, @FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var4);

    @Message(id=614, value="Cannot project on entity type '%1$s': this type cannot be loaded from an external datasource, and the documents from the index cannot be projected to its Java class '%2$s'. %3$s")
    public SearchException cannotCreateEntityProjection(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, String var3);

    @Message(id=618, value="Invalid type for entity projection on type '%1$s': the entity type's Java class '%2$s' does not extend the requested projection type '%3$s'.")
    public SearchException invalidTypeForEntityProjection(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=621, value="Cannot use rewrite method '%1$s': this method requires parameter 'n', which was not specified. Use another version of the rewrite(...) method that accepts parameter 'n'.")
    public SearchException parameterizedRewriteMethodWithoutParameter(RewriteMethod var1);

    @Message(id=622, value="Cannot use rewrite method '%1$s': this method does not accept parameter 'n', but it was specified. Use another version of the rewrite(...) method that does not accept parameter 'n'.")
    public SearchException nonParameterizedRewriteMethodWithParameter(RewriteMethod var1);

    @Message(id=624, value="Query parameter '%1$s' is not set. Use `.param(..)` methods on the query to set any parameters that the query requires.")
    public SearchException cannotFindQueryParameter(String var1);

    @Message(id=625, value="Expecting value of query parameter '%1$s' to be of type %2$s, but instead got a value of type %3$s.")
    public SearchException unexpectedQueryParameterType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=626, value="Named value '%1$s' has not been defined.")
    public SearchException namedValuesParameterNotDefined(String var1);

    @Message(id=627, value="Expecting value of named value '%1$s' to be of type %2$s, but instead got a value of type %3$s.")
    public SearchException namedValuesParameterIncorrectType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);
}

