/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.engine.logging.impl.MappingLog;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class MappingLog_$logger
implements MappingLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public MappingLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String relativeFieldNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000514: Invalid index field name '%1$s': field names cannot be null or empty.";
    }

    @Override
    public final SearchException relativeFieldNameCannotBeNullOrEmpty(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeFieldNameCannotBeNullOrEmpty$str(), relativeFieldName), context);
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String relativeFieldNameCannotContainDot$str() {
        return "HSEARCH000515: Invalid index field name '%1$s': field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.";
    }

    @Override
    public final SearchException relativeFieldNameCannotContainDot(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeFieldNameCannotContainDot$str(), relativeFieldName), context);
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexedEmbeddedCyclicRecursion$str() {
        return "HSEARCH000546: Cyclic recursion starting from '%1$s' on %2$s. Index field path starting from that location and ending with a cycle: '%3$s'. A type cannot declare an unrestricted @IndexedEmbedded to itself, even indirectly. To break the cycle, you should consider adding filters to your @IndexedEmbedded: includePaths, includeDepth, excludePaths, ...";
    }

    @Override
    public final SearchException indexedEmbeddedCyclicRecursion(MappingElement indexedEmbedded, EventContext indexedEmbeddedLocation, String cyclicRecursionPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexedEmbeddedCyclicRecursion$str(), indexedEmbedded, new EventContextNoPrefixFormatter(indexedEmbeddedLocation), cyclicRecursionPath));
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fieldTemplateNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000570: Invalid index field template name '%1$s': field template names cannot be null or empty.";
    }

    @Override
    public final SearchException fieldTemplateNameCannotBeNullOrEmpty(String templateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldTemplateNameCannotBeNullOrEmpty$str(), templateName), context);
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fieldTemplateNameCannotContainDot$str() {
        return "HSEARCH000571: Invalid index field template name '%1$s': field template names cannot contain a dot ('.').";
    }

    @Override
    public final SearchException fieldTemplateNameCannotContainDot(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldTemplateNameCannotContainDot$str(), relativeFieldName), context);
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String twoTypesTargetSameIndex$str() {
        return "HSEARCH000588: Multiple entity types mapped to index '%1$s': '%2$s', '%3$s'. Each indexed type must be mapped to its own, dedicated index.";
    }

    @Override
    public final SearchException twoTypesTargetSameIndex(String indexName, String mappedTypeName, String anotherMappedTypeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.twoTypesTargetSameIndex$str(), indexName, mappedTypeName, anotherMappedTypeName));
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String relativeNamedPredicateNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000593: Named predicate name '%1$s' is invalid: field names cannot be null or empty.";
    }

    @Override
    public final SearchException relativeNamedPredicateNameCannotBeNullOrEmpty(String relativeNamedPredicateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeNamedPredicateNameCannotBeNullOrEmpty$str(), relativeNamedPredicateName), context);
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String relativeNamedPredicateNameCannotContainDot$str() {
        return "HSEARCH000594: Named predicate name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your named predicate name.";
    }

    @Override
    public final SearchException relativeNamedPredicateNameCannotContainDot(String relativeNamedPredicateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeNamedPredicateNameCannotContainDot$str(), relativeNamedPredicateName), context);
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexNodeTypeNotComposite$str() {
        return "HSEARCH000598: Invalid type: %1$s is not composite.";
    }

    @Override
    public final SearchException invalidIndexNodeTypeNotComposite(EventContext elementContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexNodeTypeNotComposite$str(), new EventContextNoPrefixFormatter(elementContext)));
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexNodeTypeNotObjectField$str() {
        return "HSEARCH000599: Invalid type: %1$s is not an object field.";
    }

    @Override
    public final SearchException invalidIndexNodeTypeNotObjectField(EventContext elementContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexNodeTypeNotObjectField$str(), new EventContextNoPrefixFormatter(elementContext)));
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexNodeTypeNotValueField$str() {
        return "HSEARCH000600: Invalid type: %1$s is not a value field.";
    }

    @Override
    public final SearchException invalidIndexNodeTypeNotValueField(EventContext elementContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexNodeTypeNotValueField$str(), new EventContextNoPrefixFormatter(elementContext)));
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToResolveField$str() {
        return "HSEARCH000615: Unable to resolve field '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToResolveField(String absolutePath, String causeMessage, SearchException e, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToResolveField$str(), absolutePath, causeMessage), (Throwable)e, context);
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotIncludeAndExcludePathsWithinSameFilter$str() {
        return "HSEARCH000619: 'includePaths' and 'excludePaths' cannot be used together in the same filter. Use either `includePaths` or `excludePaths` leaving the other one empty. Included paths are: '%1$s', excluded paths are: '%2$s'.";
    }

    @Override
    public final SearchException cannotIncludeAndExcludePathsWithinSameFilter(Set<String> includePaths, Set<String> excludePaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotIncludeAndExcludePathsWithinSameFilter$str(), includePaths, excludePaths));
        MappingLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

