/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.engine.logging.impl.ExecutorLog;
import org.hibernate.search.util.common.SearchException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class ExecutorLog_$logger
extends DelegatingBasicLogger
implements ExecutorLog,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ExecutorLog_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ExecutorLog_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void startingExecutor(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingExecutor$str(), (Object)name);
    }

    protected String startingExecutor$str() {
        return "HSEARCH000230: Starting executor '%1$s'";
    }

    @Override
    public final void stoppingExecutor(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingExecutor$str(), (Object)indexName);
    }

    protected String stoppingExecutor$str() {
        return "HSEARCH000231: Stopping executor '%1$s'";
    }

    protected String threadInterruptedWhileSubmittingWork$str() {
        return "HSEARCH000562: Unable to submit work to '%1$s': thread received interrupt signal. The work has been discarded.";
    }

    @Override
    public final SearchException threadInterruptedWhileSubmittingWork(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.threadInterruptedWhileSubmittingWork$str(), orchestratorName));
        ExecutorLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String submittedWorkToStoppedOrchestrator$str() {
        return "HSEARCH000563: Unable to submit work to '%1$s': this orchestrator is stopped. The work has been discarded.";
    }

    @Override
    public final SearchException submittedWorkToStoppedOrchestrator(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.submittedWorkToStoppedOrchestrator$str(), orchestratorName));
        ExecutorLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void numberOfWorksInExecutor(int workCount, String name) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.numberOfWorksInExecutor$str(), (Object)workCount, (Object)name);
    }

    protected String numberOfWorksInExecutor$str() {
        return "HSEARCH000630: Processing %d works in executor '%s'";
    }

    @Override
    public final void numberOfProcessedWorksInExecutor(int workCount, String name) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.numberOfProcessedWorksInExecutor$str(), (Object)workCount, (Object)name);
    }

    protected String numberOfProcessedWorksInExecutor$str() {
        return "HSEARCH000631: Processed %d works in executor '%s'";
    }

    @Override
    public final void schedulingTask(String name) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.schedulingTask$str(), (Object)name);
    }

    protected String schedulingTask$str() {
        return "HSEARCH000632: Scheduling task '%s'.";
    }

    @Override
    public final void runningTask(String name) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.runningTask$str(), (Object)name);
    }

    protected String runningTask$str() {
        return "HSEARCH000633: Running task '%s'";
    }

    @Override
    public final void completedTask(String name) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.completedTask$str(), (Object)name);
    }

    protected String completedTask$str() {
        return "HSEARCH000634: Completed task '%s'";
    }
}

