/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.hibernate.search.engine.cfg.spi.ConfigurationProvider;
import org.hibernate.search.engine.logging.impl.ConfigurationLog;
import org.hibernate.search.util.common.SearchException;
import org.jboss.logging.Logger;

public class ConfigurationLog_$logger
implements ConfigurationLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public ConfigurationLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unableToConvertConfigurationProperty$str() {
        return "HSEARCH000501: Invalid value for configuration property '%1$s': '%2$s'. %3$s";
    }

    @Override
    public final SearchException unableToConvertConfigurationProperty(String key, Object rawValue, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToConvertConfigurationProperty$str(), key, rawValue, errorMessage), (Throwable)cause);
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unknownNameForBackend$str() {
        return "HSEARCH000533: No backend with name '%1$s'. Check that at least one entity is configured to target that backend. The following backends can be retrieved by name: %2$s. %3$s";
    }

    @Override
    public final SearchException unknownNameForBackend(String backendName, Collection<String> validBackendNames, String defaultBackendMessage) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNameForBackend$str(), backendName, validBackendNames, defaultBackendMessage));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownNameForIndexManager$str() {
        return "HSEARCH000534: No index manager with name '%1$s'. Check that at least one entity is configured to target that index. The following indexes can be retrieved by name: %2$s.";
    }

    @Override
    public final SearchException unknownNameForIndexManager(String indexManagerName, Collection<String> validIndexNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNameForIndexManager$str(), indexManagerName, validIndexNames));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidConfigurationPropertyCheckingStrategyName$str() {
        return "HSEARCH000566: Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidConfigurationPropertyCheckingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidConfigurationPropertyCheckingStrategyName$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void configurationPropertyTrackingDisabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configurationPropertyTrackingDisabled$str(), new Object[0]);
    }

    protected String configurationPropertyTrackingDisabled$str() {
        return "HSEARCH000567: Configuration property tracking is disabled; unused properties will not be logged.";
    }

    @Override
    public final void configurationPropertyTrackingUnusedProperties(Set<String> propertyKeys, String disableWarningKey, String disableWarningValue) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configurationPropertyTrackingUnusedProperties$str(), propertyKeys, (Object)disableWarningKey, (Object)disableWarningValue);
    }

    protected String configurationPropertyTrackingUnusedProperties$str() {
        return "HSEARCH000568: Invalid configuration passed to Hibernate Search: some properties in the given configuration are not used. There might be misspelled property keys in your configuration. Unused properties: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.";
    }

    protected String obsoleteConfigurationPropertiesFromSearch5$str() {
        return "HSEARCH000573: Invalid configuration passed to Hibernate Search: some properties in the given configuration are obsolete.Configuration properties changed between Hibernate Search 5 and Hibernate Search 6 Check out the reference documentation and upgrade your configuration. Obsolete properties: %1$s.";
    }

    @Override
    public final SearchException obsoleteConfigurationPropertiesFromSearch5(Set<String> propertyKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.obsoleteConfigurationPropertiesFromSearch5$str(), propertyKeys));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultBackendRegistered$str() {
        return "HSEARCH000575: No default backend. Check that at least one entity is configured to target the default backend. The following backends can be retrieved by name: %1$s.";
    }

    @Override
    public final SearchException noDefaultBackendRegistered(Collection<String> validBackendNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noDefaultBackendRegistered$str(), validBackendNames));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noBackendFactoryRegistered$str() {
        return "HSEARCH000581: Unable to resolve backend type: configuration property '%1$s' is not set, and there isn't any backend in the classpath. Check that you added the desired backend to your project's dependencies.";
    }

    @Override
    public final SearchException noBackendFactoryRegistered(String propertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noBackendFactoryRegistered$str(), propertyKey));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleBackendFactoriesRegistered$str() {
        return "HSEARCH000582: Ambiguous backend type: configuration property '%1$s' is not set, and multiple backend types are present in the classpath. Set property '%1$s' to one of the following to select the backend type: %2$s";
    }

    @Override
    public final SearchException multipleBackendFactoriesRegistered(String propertyKey, Collection<String> backendTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleBackendFactoriesRegistered$str(), propertyKey, backendTypeNames));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentMultiTenancyNamedBackend$str() {
        return "HSEARCH000596: Different mappings trying to define two backends with the same name '%1$s' but having different expectations on multi-tenancy.";
    }

    @Override
    public final SearchException differentMultiTenancyNamedBackend(String backendName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentMultiTenancyNamedBackend$str(), backendName));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentMultiTenancyDefaultBackend$str() {
        return "HSEARCH000597: Different mappings trying to define default backends having different expectations on multi-tenancy.";
    }

    @Override
    public final SearchException differentMultiTenancyDefaultBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentMultiTenancyDefaultBackend$str(), new Object[0]));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ignoringServiceConfigurationError(Class<?> serviceContract, ServiceConfigurationError error) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)error, this.ignoringServiceConfigurationError$str(), serviceContract);
    }

    protected String ignoringServiceConfigurationError$str() {
        return "HSEARCH000616: Ignoring ServiceConfigurationError caught while trying to instantiate service '%s'.";
    }

    @Override
    public final void multipleConfigurationProvidersAvailable(String scope, List<ConfigurationProvider> configurationProviders) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.multipleConfigurationProvidersAvailable$str(), (Object)scope, configurationProviders);
    }

    protected String multipleConfigurationProvidersAvailable$str() {
        return "HSEARCH000620: Multiple configuration providers are available for scope '%1$s'. They will be taken under consideration in the following order: '%2$s'.";
    }
}

